<?php
/**
 * OpenMage
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available at https://opensource.org/license/osl-3-0-php
 *
 * @category   Mage
 * @package    Mage_Captcha
 * @copyright  Copyright (c) 2006-2020 Magento, Inc. (https://www.magento.com)
 * @copyright  Copyright (c) 2022-2023 The OpenMage Contributors (https://www.openmage.org)
 * @license    https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * Captcha interface
 *
 * @category   Mage
 * @package    Mage_Captcha
 */
interface Mage_Captcha_Model_Interface
{
    /**
     * Generates captcha
     *
     * @abstract
     */
    public function generate();

    /**
     * Checks whether word entered by user corresponds to the one generated by generate()
     *
     * @abstract
     * @param string $word
     * @return void
     */
    public function isCorrect($word);

    /**
        * Get Block Name
        *
        * @return string
        */
    public function getBlockName();
}
