<?php
/**
 * OpenMage
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available at https://opensource.org/license/osl-3-0-php
 *
 * @category   Mage
 * @package    Mage_Customer
 * @copyright  Copyright (c) 2006-2020 Magento, Inc. (https://www.magento.com)
 * @copyright  Copyright (c) 2020-2023 The OpenMage Contributors (https://www.openmage.org)
 * @license    https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * Address renderer interface
 *
 * @category   Mage
 * @package    Mage_Customer
 */
interface Mage_Customer_Block_Address_Renderer_Interface
{
    /**
     * Set format type object
     *
     * @param Varien_Object $type
     */
    public function setType(Varien_Object $type);

    /**
     * Retrieve format type object
     *
     * @return Varien_Object
     */
    public function getType();

    /**
     * Render address
     *
     * @param Mage_Customer_Model_Address_Abstract $address
     * @return mixed
     */
    public function render(Mage_Customer_Model_Address_Abstract $address);
}
