<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

class Varien_Simplexml_ConfigTest extends TestCase {
    public function testSetNodeEmpty(): void {
        $data = new Varien_Simplexml_Config(<<<'XML'
<?xml version="1.0"?>
<config>
    <node>
        <data>here</data>
        <extra>
            <supplied></supplied>
        </extra>
    </node>
    <anotherNode>
        <more>data</more>
    </anotherNode>
</config>
XML);

        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "here"
                ]],
                "extra" => [[
                    "supplied" => [[
                        "#" => "",
                    ]],
                ]],
            ]],
            "anotherNode" => [[
                "more" => [[
                    "#" => "data"
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("node/data", "0");
        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "0"
                ]],
                "extra" => [[
                    "supplied" => [[
                        "#" => "",
                    ]],
                ]],
            ]],
            "anotherNode" => [[
                "more" => [[
                    "#" => "data"
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("other", null);
        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "0"
                ]],
                "extra" => [[
                    "supplied" => [[
                        "#" => "",
                    ]],
                ]],
            ]],
            "anotherNode" => [[
                "more" => [[
                    "#" => "data"
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("anotherNode", null);
        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "0"
                ]],
                "extra" => [[
                    "supplied" => [[
                        "#" => "",
                    ]],
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("node/extra/supplied", null);
        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "0"
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("node", null);
        $this->assertEquals([], $data->getInnerData());
    }
}
