<?php

declare(strict_types=1);

/**
 * @psalm-type ElementValue string|Array<string, ElementValue>
 */
class Awardit_Magento_EnvConfig_Data extends Mage_Core_Model_Config_Base {
    /**
     * @param Array<string, ElementValue> $data
     */
    public function __construct(array $data) {
        $config = new $this->_elementClass('<?xml version="1.0"?><config/>');

        self::createSimpleXML($config, $data);

        $this->_xml = $config;
    }

    /**
     * @param Array<string, ElementValue> $data
     */
    private static function createSimpleXML(SimpleXMLElement $el, array $data): void {
        if(isset($data[0])) {
            foreach($data as $value) {
                self::createSimpleXML($el, $value);
            }
        }
        else {
            foreach($data as $key => $value) {
                if(is_array($value)) {
                    self::createSimpleXML($el->addChild($key), $value);
                }
                else {
                    $el->addChild($key, $value);
                }
            }
        }
    }
}
