# MagentoLTS compatible PHP images

## Usage

To build and tag all images locally:

```bash
./build.sh
```

## Images

All images expect the application to be mounted/copied to `/app`.

The `/tmp` root-folder should preferably be mounted as tmpfs.

### Production

#### `magento-lts/php:X-cli`

Image with PHP suitable for runnning any command-line applications, jobs, or tests.

It has improved error output, will show errors in text, and logs errors to
Standard Error.

#### `magento-lts/php:X-fpm`

Container image with PHP-FPM configured for production, where errors are output
on Standard Error from the root PHP FPM process.

**NOTE:** Is still lacking `opcache.preload` and JIT in the case of PHP 8.0.

### Development

These images always revalidate opcache, expecting to be run with mutable source
mounted as a volume, and they log errors to `/app/php.log` in the container by
default to avoid polluting any attached terminal.

#### `magento-lts/php:X-dev-cli`

Image variant of `magento-lts/php:X-cli` suitable for development CLI.

#### `magento-lts/php:X-dev-cov`

The `magento-lts/php:X-dev-cli` image with [PCOV](https://github.com/krakjoe/PCOV)
installed, suitable for code coverage testing.

#### `magento-lts/php:X-dev-fpm`

Image variant of `magento-lts/php:X-fpm` suitable for development CLI.

#### `magento-lts/php:X-dev-n98`

Container image with n98-magerun as the only command configured for running
with a Magento-LTS installation or package based on it.

#### `magento-lts/php:X-dev-cli-excimer` / `magento-lts/php:X-dev-fpm-excimer`

Container image containing the Excimer low-overhead sampling profiler.
