<?php

declare(strict_types=1);

/**
 * Iterator over a list of [key, value] nodes, where the value is either data
 * to be wrapped in a Varien_Simplexml_Element or a child instance. Leaf nodes
 * will be returned as plain strings.
 *
 * @template T of Varien_Simplexml_Element
 * @implements Iterator<string, T|string>
 */
final class Varien_Simplexml_Iterator implements Iterator {

    /**
     * @param list<array{0:string, 1:array|string}> $iter
     * @param class-string<Varien_Simplexml_Element> $elementClass
     */
    public function __construct(
        // We can't have this readonly since iterating it means we are modifying it
        private array $iter,
        private readonly string $elementClass
    ) {}

    public function rewind(): void {
        reset($this->iter);
    }

    /**
     * @return T|string
     */
    public function current(): mixed {
        [$key, $value] = current($this->iter);

        return $value[Varien_Simplexml_Element::VALUE_KEY] ?? new ($this->elementClass)($key, $value);
    }

    /**
     * @return string
     */
    public function key(): mixed {
        return current($this->iter)[0];
    }

    public function next(): void {
        next($this->iter);
    }

    public function valid(): bool {
        return key($this->iter) !== null;
    }
}
