<?php

declare(strict_types=1);

// TODO: Strict types and fix inheriting classes
/**
 * Unimplemented because they are unused:
 *  * getCacheTags(): Array<string>
 *  * setCacheTags(Array<string>): void
 *  * updateCacheChecksum(string): void
 *  * fetchCacheChecksum(): bool
 *  * loadDom(DOMNode $dom): bool
 *
 * Needs implementation:
 *  * getXpath(string): array|false
 *  * getXmlString(): string   // not sure?
 *
 * @template T of Varien_Simplexml_Element
 */
class Varien_Simplexml_Config {
    final const CHECKSUM_ID_SUFFIX = "__CHECKSUM";

    /**
     * @deprecated
     */
    protected string $_elementClass = "SimpleXMLElement";

    private ?Zend_Cache_Core $cache = null;
    /**
     * Cache checksum, null if needs to be calculated, false if cache-saving is
     * disabled.
     */
    private string|null|false $cacheChecksum = null;
    private ?string $cacheId = null;
    private ?int $cacheLifetime = null;
    private bool $cacheSaved = false;
    private array $cacheTags = [];
    /**
     * @var Array<string, list<string|array>>
     */
    private array $data = [];

    public function __construct(string|SimpleXMLElement|Varien_Simplexml_Config|Varien_Simplexml_Element $sourceData = null) {
        if($sourceData === null) {
            return;
        }

        if(
            $sourceData instanceof Varien_Simplexml_Element ||
            $sourceData instanceof Varien_Simplexml_Element
        ) {
            $this->data = $sourceData->getInnerData();
        }
        elseif($sourceData instanceof SimpleXMLElement) {
            $this->setXml($sourceData);
        }
        else {
            $this->loadString($sourceData);
        }
    }

    /**
     * @return T
     */
    protected function createElement(
        string|false $name,
        array $data
    ): Varien_Simplexml_Element {
        return new Varien_Simplexml_Element($name, $data);
    }

    public function getInnerData(): array {
        return $this->data;
    }

    public function setInnerData(array $data): void {
        $this->data = $data;
    }

    public function getCache(): Zend_Cache_Core {
        return $this->cache;
    }

    public function setCache(Zend_Cache_Core $cache): void {
        $this->cache = $cache;
    }

    public function getCacheId(): ?string {
        return $this->cacheId;
    }

    public function setCacheId(string $id): void {
        $this->cacheId = $id;
    }

    public function getCacheChecksum(): string|null|false {
        return $this->cacheChecksum;
    }

    public function setCacheChecksum(string|null|false $data): void {
        $this->cacheChecksum = is_string($data) ? md5($data) : $data;
    }

    public function validateCacheChecksum(): bool {
        $newChecksum = $this->getCacheChecksum();

        if ($newChecksum === null) {
            return true;
        }

        $cacheId = $this->getCacheId();

        if( ! $cacheId || ! $newChecksum) {
            return false;
        }

        $cachedChecksum = $this->getCache()->load($cacheId.self::CHECKSUM_ID_SUFFIX);

        return $newChecksum === false && $cachedChecksum === false || $newChecksum === $cachedChecksum;
    }

    public function getCacheLifetime(): ?int {
        return $this->cacheLifetime;
    }

    public function setCacheLifetime(int $lifetime): void {
        $this->cacheLifetime = $lifetime;
    }

    public function getCacheSaved(): bool {
        return $this->cacheSaved;
    }

    public function setCacheSaved(bool $flag): void {
        $this->cacheSaved = $flag;
    }

    public function setXml(SimpleXMLElement $xml): void {
        $this->data = Varien_Simplexml_Util::simpleXmlToArray($xml);
    }

    /**
     * Loads a JSON or XML string into the configuration object, if the string
     * starts with "{" then it is considered a JSON string.
     */
    public function loadString(string $string): bool {
        if(str_starts_with($string, "{")) {
            // JSON data
            $json = json_decode($string, true);

            if( ! $json) {
                // TODO: Throw error in dev mode if we fail to load?
                return false;
            }

            $this->data = $json;

            return true;
        }

        $xml = Varien_Simplexml_Util::parseXmlString($string);

        if($xml === false) {
            return $xml;
        }

        $this->setXml($xml);

        return true;
    }

    public function loadFile(string $path): bool {
        $xml = Varien_Simplexml_Util::parseXmlFile($path);

        if($xml !== false) {
            $this->setXml($xml);
        }

        return true;
    }

    // public function getNode(string|array $path = []): Varien_Simplexml_Element|string|false {
    // TODO: Optimize?
    // TODO: Types
    /**
     * @param string|array $path
     * @return Varien_Simplexml_Element|string|false
     */
    public function getNode($path = []) {
        $parts = is_array($path) ? $path : explode("/", $path);
        $data = $this->data;

        foreach($parts as $p) {
            if( ! is_array($data) || ! array_key_exists($p, $data)) {
                return false;
            }

            $data = $data[$p][0] ?? null;
        }

        return $data[Varien_Simplexml_Element::VALUE_KEY] ?? $this->createElement(end($parts), $data);
    }

    // TODO: Test
    // TODO: Break out?
    // TODO: Performance?
    // TODO: Accept a Varien_Simplexml_Element as value?
    /**
     * Sets the given path node to the supplied value.
     */
    // Overwrite parameter is never used by anything, and if it is used it is
    // set to true which is default.
    public function setNode(
        string|array $path,
        // array|string|false|null $value
        Varien_Simplexml_Config|Varien_Simplexml_Element|string|false|null $value
    ): void {
        $parts = is_array($path) ? $path : explode("/", $path);
        /**
         * Stack of items to modify when we have reached the target node.
         *
         * @var Array<array{0:string, 1: Array<string, list<array|string>>}>
         */
        $stack = [];
        $current = $this->data;

        // Traverse down one key -> [0] step at a time
        foreach($parts as $k) {
            if(array_key_exists($k, $current)) {
                $stack[] = [$k, $current];

                $current = $current[$k][0];
            }
            else {
                $stack[] = [$k, $current];
                $current = [];
            }
        }

        if(
            $value instanceof Varien_Simplexml_Element ||
            $value instanceof Varien_Simplexml_Config
        ) {
            $current = $value->getInnerData();
        }
        else {
            $current = [
                Varien_Simplexml_Element::VALUE_KEY => $value,
            ];
        }

        // Recursively merge the differing nodes
        for($i = count($stack) - 1; $i >= 0; $i--) {
            [$k, $v] = $stack[$i];
            $v[$k] = [$current];
            $current = $v;
        }

        $this->data = $current;
    }

    public function getXPath(string $expression): Traversable {
        return $this->createElement(false, $this->data)->xpath($expression);
    }

    /**
     * @return $this
     */
    public function extend(Varien_Simplexml_Config $other, $overwrite = true): static {
        $this->data = Varien_Simplexml_Util::extendArray($this->data, $other->getInnerData(), $overwrite);

        return $this;
    }

    // TODO: Can we avoid exposing the data-arrays? They have a delicate
    // structure (the recursive Node = string|Array<key -> list<Node>> type)
    /**
     * Extend one data array with another.
     */
    public function extendData(array $data, bool $overwrite = true): void {
        $this->data = Varien_Simplexml_Util::extendArray($this->data, $data, $overwrite);
    }

    public function extendNode(
        string|array $path,
        Varien_Simplexml_Config|Varien_Simplexml_Element $node,
        bool $overwrite = true
    ): void {
        $parts = is_array($path) ? $path : explode("/", $path);
        $current = $node->getInnerData();

        for($i = count($parts) - 1; $i >= 0; $i--) {
            $current = [
                $parts[$i] => [$current],
            ];
        }

        $this->data = Varien_Simplexml_Util::extendArray($this->data, $current, $overwrite);
    }

    public function applyExtends(): void {
        // Do nothing, only paypal-module uses @extends attribute
    }

    // TODO: Types
    /**
     * @param list<string> $tags
     * @return void
     */
    public function saveCache($tags = [])
    {
        // TODO: Can we simplify this logic?
        if ($this->getCacheSaved() || $this->getCacheChecksum() === false) {
            return;
        }

        if (!is_null($this->getCacheChecksum()) && $cacheId = $this->getCacheId()) {
            $this->_saveCache(
                $this->getCacheChecksum(),
                $cacheId.self::CHECKSUM_ID_SUFFIX,
                $tags ?? [],
                $this->getCacheLifetime()
            );
        }

        $this->_saveCache($this->getJson(), $this->getCacheId(), $tags ?: [], $this->getCacheLifetime());

        $this->setCacheSaved(true);
    }

    public function loadCache(): bool {
        if (!$this->validateCacheChecksum()) {
            return false;
        }

        $xmlString = $this->_loadCache($this->getCacheId());

        if(!$xmlString) {
            return false;
        }

        $xml = json_decode($xmlString, true);

        if ( ! $xml) {
            return false;
        }

        $this->data = $xml;
        $this->setCacheSaved(true);

        return true;
    }

    // TODO: Types
    /**
     * @return void
     */
    public function removeCache() {
        $cacheId = $this->getCacheId();

        if( ! $cacheId) {
            return;
        }

        $this->_removeCache($cacheId);
        $this->_removeCache($cacheId.self::CHECKSUM_ID_SUFFIX);
    }

    // TODO: Types
    /**
     * @param string $id
     * @return string|null|false
     */
    protected function _loadCache($id) {
        return $this->getCache()->load($id);
    }

    // TODO: Types
    /**
     * @param string $data
     * @param string $id
     * @param list<string> $tags
     * @param int|false|null $lifetime
     * @return bool
     */
    protected function _saveCache($data, $id, $tags = array(), $lifetime = false)
    {
        return $this->getCache()->save($data, $id, $tags, $lifetime);
    }

    // TODO: Types
    /**
     * @param string
     * @return bool
     */
    protected function _removeCache($id)
    {
        return $this->getCache()->remove($id);
    }

    public function getJson(): string {
        return json_encode(
            $this->data,
            JSON_PRESERVE_ZERO_FRACTION |
            JSON_THROW_ON_ERROR |
            JSON_UNESCAPED_SLASHES |
            JSON_UNESCAPED_UNICODE
        );
    }
}
