<?php

declare(strict_types=1);

/**
 * Object wrapper for reading attributes using property access.
 */
final class Varien_Simplexml_Attributes {
    /**
     * @param Array<string, string>
     */
    final public function __construct(
        private readonly array $data
    ) {}

    /**
     * Getter for attribute value.
     */
    public function __get(string $name): string|false {
        return $this->data[$name] ?? false;
    }

    public function __isset(string $name): bool {
        return isset($this->data[$name]);
    }

    /**
     * Attempts to set a property will throw since attributes are read-only.
     */
    public function __set(string $name, mixed $value): void {
        throw new RuntimeException(sprintf("Attempting to set property %s::%s"), __CLASS__, $name);
    }

    /**
     * Attempts to unset a property will throw since attributes are read-only.
     */
    public function __unset(string $name): void {
        throw new RuntimeException(sprintf("Attempting to unset property %s::%s"), __CLASS__, $name);
    }
}
