<?php

declare(strict_types=1);

class Awardit_Magento_Session {
    const XML_PATH_SESSION_CONFIG = "global/session_save_config";
    const REDIS_QUERY_DEFAULTS = [
        "lockWait" => null,
        "lockRetries" => null,
        "lockTimeout" => null,
    ];
    const REDIS_QUERY_TYPES = [
        "lockWait" => "int",
        "lockRetries" => "int",
        "lockTimeout" => "int",
    ];

    public static function initRedis(): SessionHandlerInterface {
        $config = Mage::getConfig()->getNode(self::XML_PATH_SESSION_CONFIG);

        try {
            $redisConfig = Awardit_Magento_Redis::parseDsn((string)$config, self::REDIS_QUERY_DEFAULTS);
            $redisConfig = Awardit_Magento_Redis::castConfigOptions($redisConfig, self::REDIS_QUERY_TYPES);

            // Replace lifetime
            $redisConfig["lifetime"] = (int)Mage::getSingleton("core/cookie")->getLifetime();

            return new Awardit_Magento_Session_Redis($redisConfig);
        }
        catch(Exception $e) {
            throw new RuntimeException(sprintf("%s: %s in config-variable %s", __METHOD__, $e->getMessage(), Awardit_Magento_EnvConfig::ENV_SESSION), 0, $e);
        }
    }
}
