<?php

declare(strict_types=1);

class Awardit_Magento_EnvConfig_Options {
    private array $data;
    private bool $globalBanUseCache = false;

    public function __construct(array $data) {
        $this->data = array_merge(self::getDefaults(), $data);
    }

    public static function getDefaults(): array {
        $appRoot = Mage::getRoot();
        $mageRoot = dirname($appRoot);

        return [
            "app_dir" => $appRoot,
            "base_dir" => $mageRoot,
            "code_dir" => $appRoot.DIRECTORY_SEPARATOR."code",

            "design_dir" => $appRoot.DIRECTORY_SEPARATOR."design",
            "etc_dir" => $appRoot.DIRECTORY_SEPARATOR."etc",
            "etc_modules_dir" => $appRoot.DIRECTORY_SEPARATOR."etc".DIRECTORY_SEPARATOR."modules",
            "locale_dir" => $appRoot.DIRECTORY_SEPARATOR."locale",
            "media_dir" => $mageRoot.DIRECTORY_SEPARATOR."media",
            "skin_dir" => $mageRoot.DIRECTORY_SEPARATOR."skin",
        ];
    }

    public function addData(array $data): void {
        $this->data = array_merge($this->data, $data);
    }

    public function getDir(string $name): string {
        switch($name) {
        case "app":
            return $this->data["app_dir"];
        case "base":
            return $this->data["base_dir"];
        case "design":
            return $this->data["design_dir"];
        case "etc":
            return $this->data["etc_dir"];
        case "etc_modules":
            return $this->data["etc_modules_dir"];
        case "locale":
            return $this->data["locale_dir"];
        case "media":
            return $this->data["media_dir"];
        case "skin":
            return $this->data["skin_dir"];
        default:
            throw new Exception(sprintf("getDir(%s)", $name));
        }
    }

    public function getAppDir(): string {
        return $this->data["app_dir"];
    }

    public function getBaseDir(): string {
        return $this->data["base_dir"];
    }

    public function getCodeDir(): string {
        return $this->data["code_dir"];
    }

    public function getDesignDir(): string {
        return $this->data["design_dir"];
    }

    public function getEtcDir(): string {
        return $this->data["etc_dir"];
    }

    public function getEtcModulesDir(): string {
        return $this->data["etc_modules_dir"];
    }

    public function getLocaleDir(): string {
        return $this->data["locale_dir"];
    }

    public function getMediaDir(): string {
        return $this->data["media_dir"];
    }

    public function getSkinDir(): string {
        return $this->data["skin_dir"];
    }

    public function getSysTmpDir(): ?string {
        throw new Exception("SYS TMP DIR");
        // return sys_get_temp_dir();
    }

    public function getVarDir(): string {
        throw new Exception("VAR DIR");
    }

    public function getTmpDir(): string {
        throw new Exception("TMP DIR");
        // TODO: Maybe system tmp dir?
    }

    public function getCacheDir(): string {
        throw new Exception("CACHE DIR");
    }

    public function getLogDir(): string {
        throw new Exception("LOG DIR");
    }

    public function getSessionDir(): string {
        throw new Exception("SESSION DIR");
    }

    public function getUploadDir(): string {
        throw new Exception("UPLOAD DIR");
        // TODO: This should be returned properly, in system TMP
    }

    public function getExportDir(): string {
        throw new Exception("EXPORT DIR");
        // TODO: This should be returned properly, in system TMP
    }

    public function getData(string $key): mixed {
        switch($key) {
        case "global_ban_use_cache":
            return $this->globalBanUseCache;

        default:
            $e = new Exception(sprintf(
                "%s: Unknown parameters: %s",
                __METHOD__,
                json_encode(func_get_args())
            ));

            Mage::logException($e, "exception", Zend_Log::WARN);

            throw $e;
        }
    }

    public function setData(string $key, mixed $value): void {
        switch($key) {
        case "global_ban_use_cache":
            $this->globalBanUseCache = (bool)$value;

            return;

        default:
            $e = new Exception(sprintf(
                "%s: Unknown parameters: %s",
                __METHOD__,
                json_encode(func_get_args())
            ));

            Mage::logException($e, "exception", Zend_Log::WARN);

            throw $e;
        }
    }
}
