<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

class Varien_Simplexml_ConfigTest extends TestCase {
    public function testSetNodeEmpty(): void {
        $data = new Varien_Simplexml_Config(<<<'XML'
<?xml version="1.0"?>
<config>
    <node>
        <data>here</data>
        <extra>
            <supplied></supplied>
        </extra>
    </node>
    <anotherNode>
        <more>data</more>
    </anotherNode>
</config>
XML);

        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "here"
                ]],
                "extra" => [[
                    "supplied" => [[
                        "#" => "",
                    ]],
                ]],
            ]],
            "anotherNode" => [[
                "more" => [[
                    "#" => "data"
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("node/data", "0");
        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "0"
                ]],
                "extra" => [[
                    "supplied" => [[
                        "#" => "",
                    ]],
                ]],
            ]],
            "anotherNode" => [[
                "more" => [[
                    "#" => "data"
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("other", null);
        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "0"
                ]],
                "extra" => [[
                    "supplied" => [[
                        "#" => "",
                    ]],
                ]],
            ]],
            "anotherNode" => [[
                "more" => [[
                    "#" => "data"
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("anotherNode", null);
        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "0"
                ]],
                "extra" => [[
                    "supplied" => [[
                        "#" => "",
                    ]],
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("node/extra/supplied", null);
        $this->assertEquals([
            "node" => [[
                "data" => [[
                    "#" => "0"
                ]],
            ]],
        ], $data->getInnerData());

        $data->setNode("node", null);
        $this->assertEquals([], $data->getInnerData());
    }

    public function testGetNode(): void {
        $config = new Varien_Simplexml_Config(<<<'XML'
<?xml version="1.0"?>
<config>
    <node>
        <data>here</data>
        <extra>
            <supplied></supplied>
        </extra>
    </node>
    <anotherNode>
        <more>data</more>
    </anotherNode>
</config>
XML);

        $root = $config->getNode();

        $this->assertInstanceOf(Varien_Simplexml_Element::class, $root);
        $this->assertEquals("config", $root->getName());
        $this->assertTrue($root->hasChildren());

        $node = $config->getNode("node");

        $this->assertInstanceOf(Varien_Simplexml_Element::class, $node);
        $this->assertEquals("node", $node->getName());
        $this->assertTrue($node->hasChildren());

        $data = $config->getNode("node/data");

        $this->assertInstanceOf(Varien_Simplexml_Element::class, $data);
        $this->assertEquals("data", $data->getName());
        $this->assertFalse($data->hasChildren());
        $this->assertEquals("here", (string)$data);
    }

    public function testGetName(): void {
        $config = new Varien_Simplexml_Config(<<<'XML'
<?xml version="1.0"?>
<config>
    <node>
        <data>here</data>
        <extra>
            <supplied></supplied>
        </extra>
    </node>
    <anotherNode>
        <more>data</more>
    </anotherNode>
</config>
XML);

        $this->assertEquals("config", $config->getName());

        $root = $config->getNode();
        $nodes = [];

        $this->assertEquals("config", $root->getName());

        foreach($root as $node) {
            $nodes[] = $node->getName();
        }

        $this->assertEquals([
            "node",
            "anotherNode",
        ], $nodes);
    }

    // TODO: setNode with Element
}
