<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magento.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.magento.com for more information.
 *
 * @category    Mage
 * @package     Mage_Api
 * @copyright  Copyright (c) 2006-2020 Magento, Inc. (http://www.magento.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */


/**
 * ACL roles resource
 *
 * @category    Mage
 * @package     Mage_Api
 * @author      Magento Core Team <core@magentocommerce.com>
 */
class Mage_Api_Model_Resource_Roles extends Mage_Core_Model_Resource_Db_Abstract
{
    /**
     * User table name
     *
     * @var string
     */
    protected $_usersTable;

    /**
     * Rule table name
     *
     * @var string
     */
    protected $_ruleTable;

    /**
     * Resource initialization
     *
     */
    protected function _construct()
    {
        $this->_init('api/role', 'role_id');

        $this->_usersTable  = $this->getTable('api/user');
        $this->_ruleTable   = $this->getTable('api/rule');
    }

    /**
     * Action before save
     *
     * @param Mage_Core_Model_Abstract|Mage_Api_Model_Roles $object
     *
     * @return $this
     */
    protected function _beforeSave(Mage_Core_Model_Abstract $object)
    {
        if ( ! $object->getId()) {
            if ($object->getIdFieldName()) {
                $object->unsetData($object->getIdFieldName());
            } else {
                $object->unsetData('id');
            }
        }

        if ($object->getPid() > 0) {
            $row = $this->load($object->getPid());
        } else {
            $row = array('tree_level' => 0);
        }
        $object->setTreeLevel($row['tree_level'] + 1);
        $object->setRoleName($object->getName());
        return $this;
    }

    /**
     * Action after save
     *
     * @param Mage_Core_Model_Abstract $object
     *
     * @return $this
     */
    protected function _afterSave(Mage_Core_Model_Abstract $object)
    {
        $this->_updateRoleUsersAcl($object);
        Mage::app()->getCache()->clean(Zend_Cache::CLEANING_MODE_MATCHING_TAG);
        return $this;
    }

    /**
     * Action after delete
     *
     * @param Mage_Core_Model_Abstract $object
     *
     * @return $this
     */
    protected function _afterDelete(Mage_Core_Model_Abstract $object)
    {
        $adapter = $this->_getWriteAdapter();
        $adapter->delete($this->getMainTable(), array('parent_id=?'=>$object->getId()));
        $adapter->delete($this->_ruleTable, array('role_id=?'=>$object->getId()));
        return $this;
    }

    /**
     * Get role users
     *
     * @param Mage_Api_Model_Roles $role
     * @return array
     */
    public function getRoleUsers(Mage_Api_Model_Roles $role)
    {
        $adapter   = $this->_getReadAdapter();
        $select     = $adapter->select()
            ->from($this->getMainTable(), array('user_id'))
            ->where('parent_id = ?', $role->getId())
            ->where('role_type = ?', Mage_Api_Model_Acl::ROLE_TYPE_USER)
            ->where('user_id > 0');
        return $adapter->fetchCol($select);
    }

    /**
     * Update role users
     *
     * @param Mage_Api_Model_Roles $role
     * @return boolean
     */
    private function _updateRoleUsersAcl(Mage_Api_Model_Roles $role)
    {
        $users  = $this->getRoleUsers($role);
        $rowsCount = 0;
        if (count($users)) {
            $rowsCount = $this->_getWriteAdapter()->update(
                $this->_usersTable,
                array('reload_acl_flag' => 1),
                array('user_id IN(?)' => $users)
            );
        }
        return $rowsCount > 0;
    }
}
