# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [2.3.5] - 2021-12-22
### Fixed
- Error message when emails cannot be sent.

## [2.3.4] - 2021-12-22
### Added
- Better logging when emails cannot be sent.

## [2.3.3] - 2021-12-16
### Added
- Log messages now include current application store code.

## [2.3.2] - 2021-12-14
### Fixed
- Type for `Mage_Sales_Model_Quote_Item_Abstract::getParentItem`.

## [2.3.1] - 2021-12-09
### Fixed
- Removed the ability for AdminNotification to fetch feed data, which fixes
  issues where child classes are still attempting to fetch notifications.

## [2.3.0] - 2021-12-08
### Added
- Proper error levels on caught errors/warnings/notices when logging.
### Changed
- Show deprecation warnings for PEAR files.
### Removed
- AdminNotification feed updates, these slows down admin and cause errors.
- Production dependency on `psalm/plugin-phpunit`.
### Fixed
- Issue with missing weight during initial shipping/order calculation for
  quote when adding a configurable product to cart.
- Casing of `Zend_Pdf_Color_Rgb` class name.

## [2.2.3] - 2021-11-30
### Fixed
- Properly disabled `Mage_AdminNotification` module.

## [2.2.2] - 2021-11-30
### Added
- Line number for caller location in logs.
### Fixed
- Only set 500 Internal Server Error in cron script if we fail to start.

## [2.2.1] - 2021-11-29
### Fixed
- Caller information in log messages now show the correct file origin.

## [2.2.0] - 2021-11-28
### Added
- Support for a `use://connection_name` protocol for `RESOURCE_` environment
  variables which will reuse another database connection.
- Additional column `core/email_queue`.`completed_at` containing timestamp on
  successful sending of email. The queue will only remove items once they have
  gotten a completed timestamp.
- If the Datadog extension `ddtrace` is installed then logs will contain the
  current context information in the `dd` key.
### Changed
- Disabled `Mage_AdminNotification` module.
- Logging is now performed in a JSON-structure with `level`, `level_name`,
  `channel`, `message`, `context` keys.

## [2.1.1] - 2021-10-28
### Changed
- Always use flat tables if they are activated, no matter if index has finished
  running or not.

## [2.1.0] - 2021-10-28
### Added
- `sales_flat_quote`.`x_forwarded_for` column storing the `X-Forwarded-For`
  HTTP header for the last change to the quote. This will forward the header
  value to the order even if the order is created through a webhook.
- Indices for the following columns to allow for quicker filtering:
  - `sales_flat_quote`.`remote_addr`
  - `sales_flat_quote`.`x_forwarded_for`
  - `sales_flat_order`.`remote_addr`
  - `sales_flat_order`.`x_forwarded_for`
- `dependConfig` email template tag which works like a combination of `depend`
  and `config`, allowing parts of emails to be conditionally rendered based on
  system configuration.
- Wrappers for getters and setters for the following attributes:
   - `cataloginventory_stock_item.stock_status_changed_automatically`
   - `cataloginventory_stock_item.use_config_enable_qty_increments`
   - `sales_flat_shipment_track.number`
   - `sales_flat_creditmemo_item.base_weee_tax_applied_row_amount`
   - `sales_flat_invoice_item.base_weee_tax_applied_row_amount`
   - `sales_flat_order_item.base_weee_tax_applied_row_amount`
   - `sales_flat_order.payment_authorization_expiration`
   - `sales_flat_order.forced_do_shipment_with_invoice`
   - `sales_flat_order.base_shipping_hidden_tax_amount`
### Removed
- `Varien_Object` `old_fields_map` functionality.
- `Varien_Object::unsetOldData`.
- Removed deprecated attribute `cataloginventory/stock_item.stock_status_changed_automatically`.
- Removed deprecated attribute `cataloginventory/stock_item.use_config_enable_qty_increments`.
- Removed deprecated attribute `sales/shipment_track.number`.
- Removed deprecated attribute `sales/creditmemo_item.base_weee_tax_applied_row_amount`.
- Removed deprecated attribute `sales/invoice_item.base_weee_tax_applied_row_amount`.
- Removed deprecated attribute `sales/order_item.base_weee_tax_applied_row_amount`.
- Removed deprecated attribute `sales/order.payment_authorization_expiration`.
- Removed deprecated attribute `sales/order.forced_do_shipment_with_invoice`.
- Removed deprecated attribute `sales/order.base_shipping_hidden_tax_amount`.
### Fixed
- Notice error in `magento-cron` script.

## [2.0.7] - 2021-09-10
### Fixed
- Type of `$entityTypeId` parameter for `Mage_Catalog_Model_Config` methods
  `getAttributeSetName` and `getAttributeSetId`.

## [2.0.6] - 2021-09-01
### Fixed
- Missing module `config.xml` file now properly throws errors again.

## [2.0.5] - 2021-08-30
### Added
- `APP_ENV` environment `staging`: shows bootup error messages, enables developer mode, 
### Changed
- [Magento LTS 20.0.13](https://github.com/OpenMage/magento-lts/releases/tag/v20.0.13)
### Removed
- `APP_DEBUG` environment variable setting.
### Fixed
- `Varien_Image_Adapter_Gd2::destruct` crash on shutdown when image adapter has
  been created but not used.

## [2.0.4] - 2021-07-06
### Fixed
- Removed `/app/code/local` and `/app/code/community` from `.gitignore` since
  `.gitignore` affects zip package.

## [2.0.3] - 2021-06-07
### Changed
- [Magento LTS 20.0.12](https://github.com/OpenMage/magento-lts/releases/tag/v20.0.12)
### Fixed
- Support for `profiler` and `initStatements` in resource DSN.
- Better development exceptions when observer methods cannot be found.

## [2.0.2] - 2021-06-07
### Fixed
- Support for password in resource DSN.

## [2.0.1] - 2021-06-07
### Added
- Missing `Varien_Db_Adapter_Interface::getProfiler` method.
### Fixed
- Parameter name for `Mage_Core_Controller_Request_Http::setPost`.

## [2.0.0] - 2021-06-06
### Added
- Exception printing now respects `html_errors` flag, as well as sets the
  MIME-type properly.
### Changed
- New log format: `LEVEL_NAME (LEVEL) [LOG_NAME]: MESSAGE`.
- Logging is now performed using the built-in `error_log` function, respecting
  the `error_log` configuration from `php.ini`.
- Default configuration when run through provided `magento-index.php` now
  utilizes environment variables instead of any `env`-folder. See the
  [`Awardit_Magento_EnvConfig`](app/code/core/Awardit/Magento/EnvConfig.php)
  class for usable variables.
### Removed
- Ability to turn off logging.
- 404 page for cases when the store fails to load, this now results in an
  exception.
- Redirect to Installer if configuration/database is missing.
- Reports feature in favor of exception logging.

## [1.2.3] - 2021-04-28
### Fixed
- Properly populate attribute sets for single product attributes in product type
  instances.

## [1.2.2] - 2021-04-28
### Fixed
- Allow empty `MAGE_RUN_CODE` in `bin/magento-index.php`.

## [1.2.1] - 2021-04-28
### Fixed
- Proper error printing even when `STDERR` constant does not exist.
- Print startup error to stdout if debug is enabled.
- `bin/magento-index.php` is no longer executable

## [1.2.0] - 2021-04-27
### Added
- Binaries for magento index and magento cron script.
### Fixed
- Added `Mage_Customer_Model_Address_Abstract` `getCompany` and `setCompany`.
- Added `Mage_Customer_Model_Customer::setFirstname`.
- Added `Mage_Customer_Model_Customer::setLastname`.
- Added `Mage_Customer_Model_Customer::setGender`.

## [1.1.3] - 2021-04-23
### Changed
- [Magento LTS 20.0.10](https://github.com/OpenMage/magento-lts/releases/tag/v20.0.10)
### Fixed
- fix: added int $condition to `Mage_Eav_Model_Entity_Collection_Abstract`

## [1.1.2] - 2021-04-01
### Fixed
- Removed more session initialization logic in CLI mode.
- Type error with `Mage_Core_Model_Abstract::_cacheTag` in child classes.
- Type error with `Mage_Core_Model_Abstract` `getCollection` and `getResourceCollection` in child classes.
- Type error with `Mage_Index_Model_Indexer_Abstract::_matchedEntities` in child classes.

## [1.1.1] - 2021-03-16
### Fixed
- Default modules folder fallback when no `etc_modules_dir` is specified.

## [1.1.0] - 2021-03-09
### Added
- Improved error when store code/identifier does not exist in developer mode.
- Support for setting `etc_dir`, `media_dir`, and `var_dir` through `$options`
  parameter to `Mage::run` and `Mage::init`.
- `etc_modules_dir` configuration option for etc-files of modules.
### Removed
- Fallback of `tmp` dir to a temporary directory.

## [1.0.2] - 2021-03-06
### Fixed
- Updated types for `Mage_Eav_Model_Entity_Attribute_Abstract::getAttributeCode`,
  `Mage_Eav_Model_Entity_Attribute_Source_Abstract::getOptionText`, and
  `Mage_Eav_Model_Form::getAttributes`.

## [1.0.1] - 2021-03-04
### Changed
- Renamed to `awardit/magento-lts`.

## [1.0.0] - 2021-03-03
### Added
- [Magento LTS 20.0.7](https://github.com/OpenMage/magento-lts/releases/tag/v20.0.7)
- `adminhtml_catalog_customer_edit_element_types` event.
- `"No Email"` setting for emails to disable sending.
- Missing `config.xml` files now result in an exception.
- Parse errors in XML-files are now thrown.
- Support for partial index on `TEXT` field in flat tables.
- Support for alternate stock item types by checking for `checkQtyIncrements`
  method.
- Setting for cookie namespace for frontend.
- Support for running session in CLI-mode for testing.
- Support for string increment ids on order.
### Changed
- `Varien_Autoload` is replaced with Composer Autoloader.
- Unrolled `Zend_Db_Select::assemble` loop for performance.
- Fetch since attributes in configurable products instead of all of the
  attributes and sets to improve performance.
- Only update quote address `same_as_billing` if it is not already set.
### Removed
- Support for loading `*.mysql4.xml` configuration files.
- `mageFindClassFile` since we use Composer Autoloader.
- Cookie migration from old `frontend` to OpenMage `om_frontend`.
- Fallback of `var` dir to a temporary directory.
### Fixed
- Uses of `each`.
- Crash when `Varien_Object` method is invalid and parameters are too large or
  contain recursive references.
- Crash when `Varien_Image_Adapter_Gd2` image object is of the wrong type.
- Parameter and return types of `Zend_Db_Select`.
- Return types in `Varien_Db_Adapter_Pdo_Mysql`.
- Ensure connection gets closed when DB adapter gets destroyed.
- Ordering of XML totals are now correct on modern PHP versions.
- Customer address is no longer used as default for tax calculation if it is
  not allowed in the store.
- Session issues when RSS module helper is loaded.
- Improved exceptions from resources and indexers.
- Silence deprecation messages about mcrypt.
- Errors from bad parameters to vsprintf in translations.
- Required custom options were not considered on configurable options for quote
  item validation.
- Linked collection on products now return the correct size even if we did not
  load the products.
- Attribute set data missing on cached entity attribute collections.
- Product attribute value rows missing in global scope.
- Missing names, skus and option attributes on configurable products.
- Nullable properties and return types on common objects.
