# Full events list

## List

| Event name | With Magento or since OpenMage |
| ---------- | -------------- |
| [eventPrefix]_after | 1.9.4.5 |
| [eventPrefix]_clear | 1.9.4.5 |
| [eventPrefix]_delete_after | 1.9.4.5 |
| [eventPrefix]_delete_after_done | 1.9.4.5 |
| [eventPrefix]_delete_before | 1.9.4.5 |
| [eventPrefix]_delete_commit_after | 1.9.4.5 |
| [eventPrefix]_finish_before | 1.9.4.5 |
| [eventPrefix]_import_data_before | 1.9.4.5 |
| [eventPrefix]_init_virtual_grid_columns | 1.9.4.5 |
| [eventPrefix]_load_gallery_before | 1.9.4.5 |
| [eventPrefix]_merge_after | 1.9.4.5 |
| [eventPrefix]_merge_before | 1.9.4.5 |
| [eventPrefix]_move_after | 1.9.4.5 |
| [eventPrefix]_move_before | 1.9.4.5 |
| [eventPrefix]_save_after | 1.9.4.5 |
| [eventPrefix]_save_attribute_after | 1.9.4.5 |
| [eventPrefix]_save_attribute_before | 1.9.4.5 |
| [eventPrefix]_save_before | 1.9.4.5 |
| [eventPrefix]_save_commit_after | 1.9.4.5 |
| [eventPrefix]_set_sales_order | 1.9.4.5 |
| [eventPrefix]_update_grid_records | 1.9.4.5 |
| add_synchronize_message | 1.9.4.5 |
| admin_permissions_role_prepare_save | 1.9.4.5 |
| admin_session_user_login_failed | 1.9.4.5 |
| admin_session_user_login_success | 1.9.4.5 |
| admin_system_config_changed_section_[section] | 1.9.4.5 |
| admin_system_config_changed_section_currency | 1.9.4.5 |
| admin_system_config_changed_section_currency_before_reinit | 1.9.4.5 |
| admin_system_config_section_save_after | 1.9.4.5 |
| admin_user_authenticate_after | 1.9.4.5 |
| admin_user_authenticate_before | 1.9.4.5 |
| admin_user_validate | 1.9.4.5 |
| adminhtml_block_eav_attribute_edit_form_init | 1.9.4.5 |
| adminhtml_block_promo_widget_chooser_prepare_collection | 1.9.4.5 |
| adminhtml_block_salesrule_actions_prepareform | 1.9.4.5 |
| adminhtml_block_system_config_init_tab_sections_before | 1.9.4.5 |
| adminhtml_block_widget_form_init_form_values_after | 19.4.12 / 20.0.8 |
| adminhtml_block_widget_tabs_html_before | 19.4.12 / 20.0.8 |
| adminhtml_cache_flush_all | 1.9.4.5 |
| adminhtml_cache_flush_system | 1.9.4.5 |
| adminhtml_cache_refresh_type | 1.9.4.5 |
| adminhtml_catalog_category_edit_prepare_form | 1.9.4.5 |
| adminhtml_catalog_category_tabs | 1.9.4.5 |
| adminhtml_catalog_category_tree_can_add_root_category | 1.9.4.5 |
| adminhtml_catalog_category_tree_can_add_sub_category | 1.9.4.5 |
| adminhtml_catalog_category_tree_is_moveable | 1.9.4.5 |
| adminhtml_catalog_product_attribute_edit_prepare_form | 1.9.4.5 |
| adminhtml_catalog_product_attribute_set_main_html_before | 1.9.4.5 |
| adminhtml_catalog_product_attribute_set_toolbar_main_html_before | 1.9.4.5 |
| adminhtml_catalog_product_edit_tab_attributes_create_html_before | 1.9.4.5 |
| adminhtml_catalog_product_form_prepare_excluded_field_list | 1.9.4.5 |
| adminhtml_catalog_product_grid_prepare_massaction | 1.9.4.5 |
| adminhtml_cms_page_edit_tab_content_prepare_form | 1.9.4.5 |
| adminhtml_cms_page_edit_tab_design_prepare_form | 1.9.4.5 |
| adminhtml_cms_page_edit_tab_main_prepare_form | 1.9.4.5 |
| adminhtml_cms_page_edit_tab_meta_prepare_form | 1.9.4.5 |
| adminhtml_cms_page_grid_renderer_action_before_render | 1.9.4.5 |
| adminhtml_controller_action_predispatch_start | 1.9.4.5 |
| adminhtml_controller_catalogrule_prepare_save | 1.9.4.5 |
| adminhtml_controller_salesrule_prepare_save | 1.9.4.5 |
| adminhtml_customer_orders_add_action_renderer | 1.9.4.5 |
| adminhtml_customer_prepare_save | 1.9.4.5 |
| adminhtml_customer_save_after | 1.9.4.5 |
| adminhtml_init_system_config | 1.9.4.5 |
| adminhtml_promo_catalog_edit_tab_main_prepare_form | 1.9.4.5 |
| adminhtml_promo_quote_edit_tab_coupons_form_prepare_form | 1.9.4.5 |
| adminhtml_promo_quote_edit_tab_main_prepare_form | 1.9.4.5 |
| adminhtml_sales_order_create_process_data | 1.9.4.5 |
| adminhtml_sales_order_create_process_data_before | 1.9.4.5 |
| adminhtml_sales_order_create_save_before | 19.4.10 / 20.0.6 |
| adminhtml_sales_order_creditmemo_register_before | 1.9.4.5 |
| adminhtml_store_edit_form_prepare_form | 1.9.4.5 |
| adminhtml_system_config_advanced_disableoutput_render_before | 1.9.4.5 |
| adminhtml_widget_container_html_before | 1.9.4.5 |
| adminhtml_widget_grid_filter_collection | 1.9.4.5 |
| after_reindex_process_[getIndexerCode] | 1.9.4.5 |
| ajax_cart_remove_item_success | 1.9.4.5 |
| api_user_authenticated | 1.9.4.5 |
| api_user_html_before | 1.9.4.5 |
| application_clean_cache | 1.9.4.5 |
| bundle_product_view_config | 1.9.4.5 |
| catalog_block_product_list_collection | 1.9.4.5 |
| catalog_block_product_status_display | 1.9.4.5 |
| catalog_category_change_products | 1.9.4.5 |
| catalog_category_flat_loadnodes_before | 1.9.4.5 |
| catalog_category_prepare_save | 1.9.4.5 |
| catalog_controller_category_delete | 1.9.4.5 |
| catalog_controller_category_init_after | 1.9.4.5 |
| catalog_controller_category_init_before | 1.9.4.5 |
| catalog_controller_product_delete | 1.9.4.5 |
| catalog_controller_product_init | 1.9.4.5 |
| catalog_controller_product_init_after | 1.9.4.5 |
| catalog_controller_product_init_before | 1.9.4.5 |
| catalog_controller_product_mass_status | 1.9.4.5 |
| catalog_controller_product_view | 1.9.4.5 |
| catalog_helper_output_construct | 1.9.4.5 |
| catalog_model_product_duplicate | 1.9.4.5 |
| catalog_product_attribute_update_after | 1.9.4.5 |
| catalog_product_attribute_update_before | 1.9.4.5 |
| catalog_product_collection_apply_limitations_after | 1.9.4.5 |
| catalog_product_collection_apply_limitations_before | 1.9.4.5 |
| catalog_product_collection_before_add_count_to_categories | 1.9.4.5 |
| catalog_product_collection_load_after | 1.9.4.5 |
| catalog_product_collection_load_before | 1.9.4.5 |
| catalog_product_compare_add_product | 1.9.4.5 |
| catalog_product_compare_item_collection_clear | 1.9.4.5 |
| catalog_product_compare_remove_product | 1.9.4.5 |
| catalog_product_edit_action | 1.9.4.5 |
| catalog_product_edit_form_render_recurring | 1.9.4.5 |
| catalog_product_flat_prepare_columns | 1.9.4.5 |
| catalog_product_flat_prepare_indexes | 1.9.4.5 |
| catalog_product_flat_rebuild | 1.9.4.5 |
| catalog_product_flat_update_product | 1.9.4.5 |
| catalog_product_gallery_prepare_layout | 1.9.4.5 |
| catalog_product_gallery_upload_image_after | 1.9.4.5 |
| catalog_product_import_finish_before | 1.9.4.5 |
| catalog_product_is_salable_after | 1.9.4.5 |
| catalog_product_is_salable_before | 1.9.4.5 |
| catalog_product_media_add_image | 1.9.4.5 |
| catalog_product_media_save_before | 1.9.4.5 |
| catalog_product_new_action | 1.9.4.5 |
| catalog_product_status_update | 1.9.4.5 |
| catalog_product_stock_item_mass_change | 1.9.4.5 |
| catalog_product_to_website_change | 1.9.4.5 |
| catalog_product_type_grouped_price | 1.9.4.5 |
| catalog_product_type_prepare_[processMode]_options | 1.9.4.5 |
| catalog_product_upsell | 1.9.4.5 |
| catalog_product_website_update | 1.9.4.5 |
| catalog_product_website_update_before | 1.9.4.5 |
| catalogindex_get_minimal_price | 1.9.4.5 |
| catalogindex_plain_reindex_after | 1.9.4.5 |
| catalogsearch_index_process_complete | 1.9.4.5 |
| catalogsearch_index_process_start | 1.9.4.5 |
| catalogsearch_reset_search_result | 1.9.4.5 |
| catalogsearch_searchable_attributes_load_after | 1.9.4.5 |
| category_move | 1.9.4.5 |
| category_prepare_ajax_response | 1.9.4.5 |
| checkout_allow_guest | 1.9.4.5 |
| checkout_block_cart_sidebar_aftertohtml | 1.9.4.5 |
| checkout_cart_add_product_complete | 1.9.4.5 |
| checkout_cart_product_add_after | 1.9.4.5 |
| checkout_cart_product_add_before | 19.4.0 / 20.0.0 |
| checkout_cart_product_update_after | 1.9.4.5 |
| checkout_cart_save_after | 1.9.4.5 |
| checkout_cart_save_before | 1.9.4.5 |
| checkout_cart_update_item_complete | 1.9.4.5 |
| checkout_cart_update_items_after | 1.9.4.5 |
| checkout_cart_update_items_before | 1.9.4.5 |
| checkout_controller_multishipping_shipping_post | 1.9.4.5 |
| checkout_multishipping_controller_success_action | 1.9.4.5 |
| checkout_multishipping_refund_all | 1.9.4.5 |
| checkout_onepage_controller_success_action | 1.9.4.5 |
| checkout_quote_destroy | 1.9.4.5 |
| checkout_quote_init | 1.9.4.5 |
| checkout_type_multishipping_create_orders_single | 1.9.4.5 |
| checkout_type_multishipping_set_shipping_items | 1.9.4.5 |
| checkout_type_onepage_save_order | 1.9.4.5 |
| clean_catalog_images_cache_after | 1.9.4.5 |
| clean_configurable_swatches_cache_after | 1.9.4.5 |
| clean_media_cache_after | 1.9.4.5 |
| clear_expired_quotes_before | 1.9.4.5 |
| cms_controller_router_match_before | 1.9.4.5 |
| cms_generate_breadcrumbs | 1.9.4.5 |
| cms_page_get_available_statuses | 1.9.4.5 |
| cms_page_prepare_save | 1.9.4.5 |
| cms_page_render | 1.9.4.5 |
| cms_wysiwyg_config_prepare | 1.9.4.5 |
| cms_wysiwyg_images_static_urls_allowed | 1.9.4.5 |
| controller_action_layout_generate_blocks_after | 1.9.4.5 |
| controller_action_layout_generate_blocks_before | 1.9.4.5 |
| controller_action_layout_generate_xml_before | 1.9.4.5 |
| controller_action_layout_load_before | 1.9.4.5 |
| controller_action_layout_render_before | 1.9.4.5 |
| controller_action_layout_render_before_[getFullActionName] | 1.9.4.5 |
| controller_action_nocookies | 1.9.4.5 |
| controller_action_noroute | 1.9.4.5 |
| controller_action_postdispatch | 1.9.4.5 |
| controller_action_postdispatch_[getFullActionName] | 1.9.4.5 |
| controller_action_postdispatch_[getRouteName] | 1.9.4.5 |
| controller_action_predispatch | 1.9.4.5 |
| controller_action_predispatch_[getFullActionName] | 1.9.4.5 |
| controller_action_predispatch_[getRouteName] | 1.9.4.5 |
| controller_front_init_before | 1.9.4.5 |
| controller_front_init_routers | 1.9.4.5 |
| controller_front_send_response_after | 1.9.4.5 |
| controller_front_send_response_before | 1.9.4.5 |
| controller_response_redirect | 1.9.4.5 |
| core_block_abstract_prepare_layout_after | 1.9.4.5 |
| core_block_abstract_prepare_layout_before | 1.9.4.5 |
| core_block_abstract_to_html_after | 1.9.4.5 |
| core_block_abstract_to_html_before | 1.9.4.5 |
| core_clean_cache | 1.9.4.5 |
| core_collection_abstract_load_after | 1.9.4.5 |
| core_collection_abstract_load_before | 1.9.4.5 |
| core_copy_fieldset_[fieldset]_[aspect] | 1.9.4.5 |
| core_layout_block_create_after | 1.9.4.5 |
| core_locale_set_locale | 1.9.4.5 |
| core_session_abstract_add_message | 1.9.4.5 |
| core_session_abstract_clear_messages | 1.9.4.5 |
| create_order_session_quote_initialized | 1.9.4.5 |
| currency_display_options_forming | 1.9.4.5 |
| custom_quote_process | 1.9.4.5 |
| customer_address_format | 1.9.4.5 |
| customer_address_validation_after | 1.9.4.5 |
| customer_customer_authenticated | 1.9.4.5 |
| customer_login | 1.9.4.5 |
| customer_logout | 1.9.4.5 |
| customer_register_success | 1.9.4.5 |
| customer_registration_is_allowed | 1.9.4.5 |
| customer_session_init | 1.9.4.5 |
| eav_collection_abstract_load_before | 1.9.4.5 |
| end_index_events_[getEventTypeName] | 1.9.4.5 |
| end_process_event_[getEventTypeName] | 1.9.4.5 |
| gift_options_prepare_items | 1.9.4.5 |
| http_response_send_before | 1.9.4.5 |
| index_process_change_status | 1.9.4.5 |
| init_from_order_session_quote_initialized | 1.9.4.5 |
| load_customer_quote_before | 1.9.4.5 |
| log_log_clean_after | 1.9.4.5 |
| log_log_clean_before | 1.9.4.5 |
| log_visitor_collection_load_before | 1.9.4.5 |
| mage_run_exception | 1.9.4.5 |
| model_config_data_save_before | 1.9.4.5 |
| model_delete_after | 1.9.4.5 |
| model_delete_before | 1.9.4.5 |
| model_delete_commit_after | 1.9.4.5 |
| model_load_after | 1.9.4.5 |
| model_load_before | 1.9.4.5 |
| model_save_after | 1.9.4.5 |
| model_save_before | 1.9.4.5 |
| model_save_commit_after | 1.9.4.5 |
| on_view_report | 1.9.4.5 |
| order_cancel_after | 1.9.4.5 |
| page_block_html_topmenu_gethtml_after | 1.9.4.5 |
| page_block_html_topmenu_gethtml_before | 1.9.4.5 |
| payment_form_block_to_html_before | 1.9.4.5 |
| payment_info_block_prepare_specific_information | 1.9.4.5 |
| payment_method_is_active | 1.9.4.5 |
| paypal_prepare_line_items | 1.9.4.5 |
| pdf_item_draw_after | 1.9.4.5 |
| permissions_block_html_before | 1.9.4.5 |
| permissions_user_html_before | 1.9.4.5 |
| permissions_variable_html_before | 1.9.4.5 |
| poll_vote_add | 1.9.4.5 |
| prepare_product_children_id_list_select | 1.9.4.5 |
| product_duplicate_attributes | 1.9.4.5 |
| product_option_renderer_init | 1.9.4.5 |
| resource_get_tablename | 1.9.4.5 |
| review_controller_product_init | 1.9.4.5 |
| review_controller_product_init_after | 1.9.4.5 |
| review_controller_product_init_before | 1.9.4.5 |
| review_review_collection_load_before | 1.9.4.5 |
| rss_catalog_category_xml_callback | 1.9.4.5 |
| rss_catalog_new_xml_callback | 1.9.4.5 |
| rss_catalog_notify_stock_collection_select | 1.9.4.5 |
| rss_catalog_review_collection_select | 1.9.4.5 |
| rss_catalog_special_xml_callback | 1.9.4.5 |
| rss_catalog_tagged_item_xml_callback | 1.9.4.5 |
| rss_order_new_collection_select | 1.9.4.5 |
| rss_wishlist_xml_callback | 1.9.4.5 |
| rule_environment_collect | 1.9.4.5 |
| sales_convert_order_item_to_quote_item | 1.9.4.5 |
| sales_convert_quote_address_to_order | 1.9.4.5 |
| sales_convert_quote_address_to_order_address | 1.9.4.5 |
| sales_convert_quote_item_to_order_item | 1.9.4.5 |
| sales_convert_quote_payment_to_order_payment | 1.9.4.5 |
| sales_convert_quote_to_order | 1.9.4.5 |
| sales_model_service_quote_submit_after | 1.9.4.5 |
| sales_model_service_quote_submit_before | 1.9.4.5 |
| sales_model_service_quote_submit_failure | 1.9.4.5 |
| sales_model_service_quote_submit_success | 1.9.4.5 |
| sales_order_creditmemo_cancel | 1.9.4.5 |
| sales_order_creditmemo_refund_before | 19.4.15 / 20.0.13 |
| sales_order_creditmemo_refund | 1.9.4.5 |
| sales_order_invoice_cancel | 1.9.4.5 |
| sales_order_invoice_pay | 1.9.4.5 |
| sales_order_invoice_register | 1.9.4.5 |
| sales_order_item_cancel | 1.9.4.5 |
| sales_order_payment_cancel | 1.9.4.5 |
| sales_order_payment_cancel_creditmemo | 1.9.4.5 |
| sales_order_payment_cancel_invoice | 1.9.4.5 |
| sales_order_payment_capture | 1.9.4.5 |
| sales_order_payment_pay | 1.9.4.5 |
| sales_order_payment_place_end | 1.9.4.5 |
| sales_order_payment_place_start | 1.9.4.5 |
| sales_order_payment_refund | 1.9.4.5 |
| sales_order_payment_void | 1.9.4.5 |
| sales_order_place_after | 1.9.4.5 |
| sales_order_place_before | 1.9.4.5 |
| sales_order_status_unassign_before | 1.9.4.5 |
| sales_prepare_amount_expression | 1.9.4.5 |
| sales_quote_add_item | 1.9.4.5 |
| sales_quote_config_get_product_attributes | 1.9.4.5 |
| sales_quote_item_collection_products_after_load | 1.9.4.5 |
| sales_quote_item_qty_set_after | 1.9.4.5 |
| sales_quote_item_set_product | 1.9.4.5 |
| sales_quote_product_add_after | 1.9.4.5 |
| sales_quote_remove_item | 1.9.4.5 |
| sales_sale_collection_query_before | 1.9.4.5 |
| salesrule_rule_condition_combine | 1.9.4.5 |
| salesrule_rule_get_coupon_types | 1.9.4.5 |
| salesrule_validator_process | 1.9.4.5 |
| sendfriend_product | 1.9.4.5 |
| sitemap_categories_generating_before | 1.9.4.5 |
| sitemap_cms_pages_generating_before | 19.4.0 / 20.0.0 |
| sitemap_products_generating_before | 1.9.4.5 |
| sitemap_urlset_generating_before | 19.4.0 / 20.0.0 |
| start_index_events_[getEventTypeName] | 1.9.4.5 |
| start_process_event_[getEventTypeName] | 1.9.4.5 |
| store_add | 1.9.4.5 |
| store_delete | 1.9.4.5 |
| store_edit | 1.9.4.5 |
| store_group_save | 1.9.4.5 |
| tag_tag_product_collection_load_after | 1.9.4.5 |
| tax_rate_data_fetch | 1.9.4.5 |
| visitor_init | 1.9.4.5 |
| wishlist_add_item | 1.9.4.5 |
| wishlist_add_product | 1.9.4.5 |
| wishlist_item_add_after | 1.9.4.5 |
| wishlist_item_collection_products_after_load | 1.9.4.5 |
| wishlist_items_renewed | 1.9.4.5 |
| wishlist_product_add_after | 1.9.4.5 |
| wishlist_share | 1.9.4.5 |
| wishlist_update_item | 1.9.4.5 |

## Example

For example, if you want to add custom logic for `customer_login` event.
Add in your `config.xml`:

```xml
<config>
    <global><!-- or adminhtml or frontend -->
        <events>
            <customer_login>
                <observers>
                    <yourNamespace_yourModule>
                        <class>yourShortClass/observer</class>
                        <method>yourMethod</method>
                    </yourNamespace_yourModule>
                </observers>
            </customer_login>
        </events>
    </global>
</config>
```

And in your `Observer.php`:

```php
class YourNamespace_YourModule_Model_Observer {

    // EVENT customer_login
    public function yourMethod(Varien_Event_Observer $observer) {
        $customer = $observer->getData('customer');
    }
}