#!/usr/bin/env bash

set -e

function version { echo "$@" | awk -F. '{ printf("%d%03d%03d%03d\n", $1,$2,$3,$4); }'; }

SCRIPT_NAME=$(basename "$0")
SCRIPT_PATH=$(dirname $(readlink -f $0))

if ! command -v docker &> /dev/null; then
	echo "$SCRIPT_NAME: Docker CLI is required"

	exit -1
fi

DOCKER_VERSION=$(docker version --format '{{.Client.Version}}')

if [ $(version $DOCKER_VERSION) -lt $(version "17.05.0") ]; then
	echo "$SCRIPT_NAME: Docker client version 17.05.0 required, installed: $DOCKER_VERSION"

	exit -1
fi

set -x

CLI_IMAGE_TYPES=(
	"cli"
	"dev-cli"
	"dev-cov"
	"dev-n98"
)
FPM_IMAGE_TYPES=(
	"fpm"
	"dev-fpm"
)
PHP_VERSIONS=(
	"7.4"
	"8.0"
)

for PHP_VERSION in "${PHP_VERSIONS[@]}"; do
	for IMAGE_TYPE in "${CLI_IMAGE_TYPES[@]}"; do
		docker build "$SCRIPT_PATH/php" \
			--build-arg BASE_IMAGE="php:$PHP_VERSION-cli-alpine" \
			--target "php-$IMAGE_TYPE" \
			-t "magento-lts/php:$PHP_VERSION-$IMAGE_TYPE"
	done

	for IMAGE_TYPE in "${FPM_IMAGE_TYPES[@]}"; do
		docker build "$SCRIPT_PATH/php" \
			--build-arg BASE_IMAGE="php:$PHP_VERSION-fpm-alpine" \
			--target "php-$IMAGE_TYPE" \
			-t "magento-lts/php:$PHP_VERSION-$IMAGE_TYPE"
	done
done

