# MagentoLTS compatible PHP images

## Usage

To build and tag all images locally:

```bash
./build.sh
```

## Images

### `magento-lts/php:X-cli`

Container image with PHP suitable for runnning any command-line applications, jobs, or tests.

It has improved error output, will show errors in text, and logs errors to
`/app/php.log` in the container by default.

**NOTE:** Production scripts/jobs should use the `-d` flag to redirect
`error_log` to Standard Error, or otherwise provide an alternate configuration
for logging to ensure logs are seen and prevent modifications on top of the
base image.

### `magento-lts/php:X-cov`

The `magento-lts/php:X-cli` image with [PCOV](https://github.com/krakjoe/PCOV)
installed, suitable for code coverage testing.

### `magento-lts/php:X-n98`

Container image with n98-magerun as the only command configured for running
with a Magento-LTS installation or package based on it.

### `magento-lts/php:X-fpm`

Container image with PHP-FPM configured for production, where errors are output
on Standard Error from the root PHP FPM process.

**NOTE:** Is still lacking some performance optimizations, like
`opcache.validate_timestamps` or `opcache.preload`.
