<?php

// These cannot fail
$environment = getenv("APP_ENV") ?: "development";
$debug = strtolower(trim(getenv("APP_DEBUG") ?: (in_array($environment, ["development", "test"]) ? "true" : "false"))) === "true";
$mageRunCode = getenv("MAGE_RUN_CODE");
$mageRunType = getenv("MAGE_RUN_TYPE");
$projectDir = null;
$packageDir = dirname(__DIR__);
$paths = [
    // Package itself
    $packageDir,
    // Installed as a dependency in /vendor/awardit/magento-lts
    dirname(dirname(dirname($packageDir))),
];

error_reporting(E_ALL | E_STRICT);
ini_set("display_errors", $debug ? 1 : 0);
umask(0);
http_response_code(500);

foreach($paths as $path) {
    if(file_exists($path."/vendor/autoload.php")) {
        $projectDir = $path;

        break;
    }
}

/**
 * @return no-return
 */
function __bin_magento_exitError(string $message): void {
    global $debug;

    if($debug && PHP_SAPI !== "cli") {
        echo $message."\n";
    }

    file_put_contents("php://stderr", $message."\n");

    exit(-1);
}

if(PHP_SAPI === "cli") {
    __bin_magento_exitError(sprintf(
        "%s: This file should only be run through FastCGI\n",
        __FILE__
    ));
}

if( ! $projectDir) {
    __bin_magento_exitError(sprintf(
        "%s: Composer vendor directory not found, please run composer install. Tried %s.\n",
        __FILE__,
        implode(", ", array_map(function(string $str): string { return "'$str'"; }, $paths))
    ));
}

if($mageRunCode === null) {
    __bin_magento_exitError(sprintf(
        "%s: Required environment variable 'MAGE_RUN_CODE' is not set.\n",
        __FILE__
    ));
}

if($mageRunType === null) {
    __bin_magento_exitError(sprintf(
        "%s: Required environment variable 'MAGE_RUN_TYPE' is not set.\n",
        __FILE__
    ));
}

require_once $projectDir."/vendor/autoload.php";
require_once $packageDir."/app/Mage.php";

if($debug) {
    Mage::setIsDeveloperMode($debug);
}

Mage::run($mageRunCode, $mageRunType, [
    "etc_dir" => $projectDir."/etc",
    "var_dir" => $projectDir."/var",
    "media_dir" => $projectDir."/media",
    // Modules are still installed in the vendor tree
    "etc_modules_dir" => $packageDir."/app/etc/modules",
]);
