# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.0.1] - 2020-03-04
### Changed
- Renamed to `awardit/magento-lts`.

## [1.0.0] - 2020-03-03
### Added
- Magento LTS 20.0.7.
- `adminhtml_catalog_customer_edit_element_types` event.
- `"No Email"` setting for emails to disable sending.
- Missing `config.xml` files now result in an exception.
- Parse errors in XML-files are now thrown.
- Support for partial index on `TEXT` field in flat tables.
- Support for alternate stock item types by checking for `checkQtyIncrements`
  method.
- Setting for cookie namespace for frontend.
- Support for running session in CLI-mode for testing.
- Support for string increment ids on order.
### Changed
- `Varien_Autoload` is replaced with Composer Autoloader.
- Unrolled `Zend_Db_Select::assemble` loop for performance.
- Fetch since attributes in configurable products instead of all of the
  attributes and sets to improve performance.
- Only update quote address `same_as_billing` if it is not already set.
### Removed
- Support for loading `*.mysql4.xml` configuration files.
- `mageFindClassFile` since we use Composer Autoloader.
- Cookie migration from old `frontend` to OpenMage `om_frontend`.
- Fallback of `var` dir to a temporary directory.
### Fixed
- Uses of `each`.
- Crash when `Varien_Object` method is invalid and parameters are too large or
  contain recursive references.
- Crash when `Varien_Image_Adapter_Gd2` image object is of the wrong type.
- Parameter and return types of `Zend_Db_Select`.
- Return types in `Varien_Db_Adapter_Pdo_Mysql`.
- Ensure connection gets closed when DB adapter gets destroyed.
- Ordering of XML totals are now correct on modern PHP versions.
- Customer address is no longer used as default for tax calculation if it is
  not allowed in the store.
- Session issues when RSS module helper is loaded.
- Improved exceptions from resources and indexers.
- Silence deprecation messages about mcrypt.
- Errors from bad parameters to vsprintf in translations.
- Required custom options were not considered on configurable options for quote
  item validation.
- Linked collection on products now return the correct size even if we did not
  load the products.
- Attribute set data missing on cached entity attribute collections.
- Product attribute value rows missing in global scope.
- Missing names, skus and option attributes on configurable products.
- Nullable properties and return types on common objects.
