<?php
/**
 * OpenMage
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available at https://opensource.org/license/osl-3-0-php
 *
 * @category   Mage
 * @package    Mage_Paygate
 * @copyright  Copyright (c) 2006-2020 Magento, Inc. (https://www.magento.com)
 * @copyright  Copyright (c) 2022 The OpenMage Contributors (https://www.openmage.org)
 * @license    https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/** @var Mage_Core_Model_Resource_Setup $installer */
$installer = $this;
$installer->startSetup();

/**
 * Table for fulltext search needs to be InnoDB.
 *
 * When MyISAM it only returns integer for fulltext searches, 0 and 1. But to
 * make it return floats in boolean mode, it needs to be InnoDB.
 */
$installer->run("
ALTER TABLE `{$installer->getTable('catalogsearch_fulltext')}` ENGINE = InnoDB;
");

$installer->endSetup();
