<?php
/**
 * OpenMage
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available at https://opensource.org/license/osl-3-0-php
 *
 * @category   Mage
 * @package    Mage_Paypal
 * @copyright  Copyright (c) 2006-2020 Magento, Inc. (https://www.magento.com)
 * @copyright  Copyright (c) 2022 The OpenMage Contributors (https://www.openmage.org)
 * @license    https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

$installer = $this;
/* @var Mage_Catalog_Model_Resource_Setup $installer */

$installer->startSetup();


// These two tables has "position" as unsigned, but source tables are signed.
$installer->getConnection()->modifyColumn(
    $installer->getTable('catalog/category_anchor_products_indexer_idx'),
    'position',
    array(
        'type'      => Varien_Db_Ddl_Table::TYPE_INTEGER,
        'unsigned'  => false,
        'nullable'  => true,
        'default'   => null,
        'comment'   => 'Position'
    )
);
$installer->getConnection()->modifyColumn(
    $installer->getTable('catalog/category_anchor_products_indexer_tmp'),
    'position',
    array(
        'type'      => Varien_Db_Ddl_Table::TYPE_INTEGER,
        'unsigned'  => false,
        'nullable'  => true,
        'default'   => null,
        'comment'   => 'Position'
    )
);

$installer->endSetup();
