<?php

// These cannot fail
$appEnv = strtolower(trim($_SERVER["APP_ENV"] ?? "development"));
$projectDir = null;
$packageDir = dirname(__DIR__);
$paths = [
    // Package itself
    $packageDir,
    // Installed as a dependency in /vendor/awardit/magento-lts
    dirname(dirname(dirname($packageDir))),
];

error_reporting(E_ALL | E_STRICT);
ini_set("display_errors", in_array($appEnv, ["development", "test"]) ? "1" : "0");
umask(0);
http_response_code(500);

foreach($paths as $path) {
    if(file_exists($path."/vendor/autoload.php")) {
        $projectDir = $path;

        break;
    }
}

/**
 * @return no-return
 */
function __bin_magento_exitError(string $message) {
    global $appEnv;

    if(in_array($appEnv, ["staging", "development", "test"]) && PHP_SAPI !== "cli") {
        echo $message."\n";
    }

    file_put_contents("php://stderr", $message."\n");

    exit(-1);
}

if(PHP_SAPI === "cli") {
    __bin_magento_exitError(sprintf(
        "%s: This file should only be run through FastCGI\n",
        __FILE__
    ));
}

if( ! $projectDir) {
    __bin_magento_exitError(sprintf(
        "%s: Composer vendor directory not found, please run composer install. Tried %s.\n",
        __FILE__,
        implode(", ", array_map(function(string $str): string { return "'$str'"; }, $paths))
    ));
}

$REQUIRED_SERVER = [
    "MAGE_RUN_CODE",
    "MAGE_RUN_TYPE",
];

foreach($REQUIRED_SERVER as $key) {
    if( ! array_key_exists($key, $_SERVER)) {
        __bin_magento_exitError(sprintf(
            "%s: Required FastCGI param '%s' is not set.\n",
            __FILE__,
            $key
        ));
    }
}

// We are magento
$magentoDir = $packageDir;

/** @psalm-suppress UnresolvableInclude */
require_once $projectDir."/vendor/autoload.php";
/** @psalm-suppress UnresolvableInclude */
require_once $magentoDir."/app/Mage.php";

if(in_array($appEnv, ["staging", "development", "test"])) {
    Mage::setIsDeveloperMode(true);
}

Mage::run($_SERVER["MAGE_RUN_CODE"], $_SERVER["MAGE_RUN_TYPE"], [
    // Run envronment configuration
    "config_model" => "Awardit_Magento_EnvConfig",
    "env_config" => $_SERVER,
    "is_installed" => true,

    "etc_dir" => $projectDir."/etc",
    "var_dir" => $projectDir."/var",
    "media_dir" => $projectDir."/media",
    // Modules are still installed in the vendor tree
    "etc_modules_dir" => $magentoDir."/app/etc/modules",
]);
