<?php

/**
 * Installs attributes related to AWS events.
 */

/**
 * @var Mage_Catalog_Model_Resource_Setup $installer
 * @psalm-suppress InvalidScope
 */
$installer = $this;
$installer->startSetup();

$entityTypeId = (int)Mage::getModel('catalog/product')->getResource()->getEntityType()->getId();

// Ensure "supplier" product attribute
$sropship = $installer->getAttribute($entityTypeId, 'awardit_dropship');
if (empty($sropship)) {
    $installer->addAttribute($entityTypeId, 'awardit_dropship', [
        'group'         => 'General',
        'type'          => 'int',
        'label'         => 'Dropship product',
        'input'         => 'select',
        'source'        => 'eav/entity_attribute_source_boolean',
        'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible'       => true,
        'required'      => false,
        'default'       => Mage_Eav_Model_Entity_Attribute_Source_Boolean::VALUE_NO,
        'user_defined'  => false,
        'apply_to'      => 'simple',
    ]);
}

$installer->endSetup();
