<?php

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class Awardit_EventListener_Model_Schema extends MageQL_Core_Model_Schema_Abstract
{
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder
    {
        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array
    {
        switch ($typeName) {
            case 'ListProduct':
            case 'ProductDetail':
                return [
                    'lowestSalePrice' => $this->field('ProductPrice', 'Lowest sale price 30 days')
                        ->setResolver(function (Mage_Catalog_Model_Product $src): ?MageQL_Core_Model_Price_Abstract {
                            $price = $src->getLowestSalePrice();
                            return $price ? new MageQL_Catalog_Model_Product_Price($src, $price) : null;
                        }),
                ];
        }
        return [];
    }
}
