<?php

/**
 * Installs attributes related to AWS events.
 */

/**
 * @var Mage_Catalog_Model_Resource_Setup $installer
 * @psalm-suppress InvalidScope
 */
$installer = $this;
$installer->startSetup();

$entityTypeId = (int)Mage::getModel('catalog/product')->getResource()->getEntityType()->getId();

// Ensure "supplier" product attribute
$supplier = $installer->getAttribute($entityTypeId, 'supplier');
if (empty($supplier)) {
    $installer->addAttribute($entityTypeId, 'supplier', [
        'group'         => 'General',
        'type'          => 'int',
        'label'         => 'Supplier',
        'input'         => 'select',
        'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
        'visible'       => true,
        'required'      => false,
        'default'       => null,
        'user_defined'  => false,
    ]);
}

$installer->endSetup();
