<?php

/**
 * @method getEventType()
 * @method setEventType(string $type)
 * @method getRevision()
 * @method setRevision(int $revision)
 * @method getProductId()
 * @method setProductId(int $id)
 * @method getStoreId()
 * @method setStoreId(int $id)
 * @method getLogId()
 * @method getPreviousLogId()
 * @method setPreviousLogId(int $id)
 *
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_EventListener_Model_Event_Log extends Mage_Core_Model_Abstract
{
    /**
     * Load latest event log by product/store/type
     * @param int|string $product_id
     */
    public function loadLatest($product_id, ?int $store_id, string $event_type): self
    {
        /** @var Awardit_EventListener_Model_Resource_Event_Log $resource */
        $resource = $this->getResource();
        $data = $resource->loadLatest((int)$product_id, $store_id, $event_type);
        $this->setData($data === false ? [] : $data);
        return $this;
    }

    public function getEventData(): array
    {
        return json_decode($this->getData('event_data') ?? '[]', true);
    }

    public function setEventData(array $data): void
    {
        $this->setData('event_data', json_encode($data));
    }

    public function getStore(): ?Mage_Core_Model_Store
    {
        $store = Mage::getModel('core/store')->load($this->getStoreId());
        return $store->getId() ? $store : null;
    }

    /**
     * Initialize object.
     */
    protected function _construct(): void
    {
        $this->_init('awardit_eventlistener/event_log');
    }
}
