<?php

class Awardit_EventListener_EventException extends RuntimeException
{
    private bool $permanent;

    public function __construct(bool $permanent = false)
    {
        $this->permanent = $permanent;
        parent::__construct(
            $permanent
            ? 'Permanent, remove from queue'
            : 'Uncertain, keep in queue'
        );
    }

    public function isPermanent(): bool
    {
        return $this->permanent;
    }
}
