<?php

error_reporting(~E_DEPRECATED);

function __try_realpath(string $path): string
{
    return realpath($path) ?: $path;
}

$env = getenv();
$vendorDir = __try_realpath(dirname($_composer_autoload_path) ?? __DIR__ . '/../vendor');
$projectDir = dirname($vendorDir);

require "{$vendorDir}/autoload.php";
require "{$vendorDir}/awardit/magento-lts/app/Mage.php";

// Set up Magento
Mage::register('isSecureArea', true);

$options = [
    // Environment configuration
    'config_model' => "Awardit_Magento_EnvConfig",
    'is_installed' => true,
    'etc_dir' => __try_realpath($env['MAGE_ETC_DIR'] ?? "{$projectDir}/etc"),
    'var_dir' => __try_realpath($env['MAGE_VAR_DIR'] ?? "{$projectDir}/var"),
    'cache_dir' => __try_realpath($env['MAGE_CACHE_DIR'] ?? "{$projectDir}/var/cache"),
    'media_dir' => __try_realpath($env['MAGE_MEDIA_DIR'] ?? "{$projectDir}/media"),
    'etc_modules_dir' => "{$vendorDir}/awardit/magento-lts/app/etc/modules",
];
while (true) {
    try {
        // Boot as admin to allow product modifications
        Mage::init('admin', 'store', $options);

        // Run worker
        $worker = new Awardit_EventListener_Worker();
        $worker->run();
    } catch (Zend_Db_Statement_Exception $e) {
        // Reset Magento whenever an exception leaks through
        Mage::logException($e);
        Mage::reset();
        sleep(1);
    } catch (Throwable $e) {
        Mage::logException($e);
        throw $e;
    }
}
