<?php

class Awardit_EventListener_Helper_Data extends Mage_Core_Helper_Abstract
{
    /**
     * Get Magento tax class id by external ERP tax class.
     */
    public function getTaxClassId(string $erp_tax_class): int
    {
        $map = $this->getTaxMapping();
        if (!array_key_exists($erp_tax_class, $map)) {
            throw new Mage_Core_Exception("ERP Tax class {$erp_tax_class} is not mapped.");
        }
        return (int)$map[$erp_tax_class];
    }

    /**
     * Load store-level product and ingore inherited attribute values.
     */
    public function loadProduct(string $sku, int $store_id): Mage_Catalog_Model_Product
    {
        $product = Mage::getModel('catalog/product');
        $product->setStoreId($store_id);
        $id = $product->getIdBySku($sku);
        if (!$id) {
            throw new Awardit_EventListener_EventException("Failed to obtain Product with SKU '$sku'", false);
        }
        $product->load($id);
        // Reset inherited values
        foreach ($product->getAttributes() as $at) {
            if ($at->getId() && !$at->isScopeGlobal() && !$product->getExistsStoreValueFlag($at->getAttributeCode())) {
                $product->setData($at->getAttributeCode(), false);
            }
        }
        return $product;
    }

    private function getTaxMapping(): array
    {
        $unserializer = Mage::helper('core/unserializeArray');
        /** @var string */
        $map = Mage::getStoreConfig('awardit_aws/mappings/tax_mapping');
        if (empty($map)) {
            return []; // Might be null
        }
        $map = $unserializer->unserialize($map);
        /** @var array<string, string> */
        $return = [];
        foreach ($map as $item) {
            if (empty($item['erp_tax_code']) || empty($item['tax_class_id'])) {
                continue; // Not a valid mapping
            }
            $return[$item['erp_tax_code']] = $item['tax_class_id'];
        }
        return $return;
    }
}
