<?php

/**
 * Installs attributes related to AWS events.
 */

/**
 * @var Mage_Catalog_Model_Resource_Setup $installer
 * @psalm-suppress InvalidScope
 */
$installer = $this;
$installer->startSetup();

$connection = $installer->getConnection();

$entityTypeId = (int)Mage::getModel('catalog/product')->getResource()->getEntityType()->getId();
$setId = (int)$installer->getEntityTypeId('catalog_product');

// Ensure "manufacturer" product attribute
$manufacturer = $installer->getAttribute($entityTypeId, 'manufacturer');
if (empty($manufacturer)) {
    $installer->addAttribute($entityTypeId, 'manufacturer', [
        'group'                     => 'General',
        'type'                      => 'int',
        'label'                     => 'Manufacturer',
        'input'                     => 'select',
        'global'                    => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible'                   => true,
        'required'                  => false,
        'default'                   => null,
        'is_configurable'           => false,
        'used_in_product_listing'   => true,
        'user_defined'              => false,
    ]);
}
$installer->addAttributeToSet($entityTypeId, $setId, 'General', 'manufacturer');

// Add event log table
$event_table = $connection->newTable($installer->getTable('awardit_eventlistener/event_log'))
    ->addColumn('log_id', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'identity'  => true,
        'unsigned'  => true,
        'nullable'  => false,
        'primary'   => true,
    ], 'Log id')
    ->addColumn('previous_log_id', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'unsigned'  => true,
        'nullable'  => true,
    ], 'Previous log id')
     ->addColumn('revision', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Revision')
    ->addColumn('product_id', Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        'unsigned'  => true,
        'nullable'  => false,
    ], 'Product id')
    ->addColumn('store_id', Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        'unsigned'  => true,
        'nullable'  => true,
    ], 'Store id')
    ->addColumn('created_at', Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        'nullable'  => false,
        'default'   => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn('event_type', Varien_Db_Ddl_Table::TYPE_TEXT, 32, [
        'nullable'  => false,
    ], 'Event type')
    ->addColumn('event_data', Varien_Db_Ddl_Table::TYPE_TEXT, null, [
        'nullable'  => false,
    ])
    ->addForeignKey(
        $installer->getFkName(
            'awardit_eventlistener/event_log',
            'store_id',
            'core/store',
            'store_id'
        ),
        'store_id',
        $installer->getTable('core/store'),
        'store_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addForeignKey(
        $installer->getFkName(
            'awardit_eventlistener/event_log',
            'product_id',
            'catalog/product',
            'entity_id'
        ),
        'product_id',
        $installer->getTable('catalog/product'),
        'entity_id',
        Varien_Db_Ddl_Table::ACTION_CASCADE,
        Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->addIndex(
        $installer->getIdxName(
            'awardit_eventlistener/event_log',
            [
                'product_id',
                'store_id',
                'event_type',
                'revision',
            ]
        ),
        [
            'product_id',
            'store_id',
            'event_type',
            'revision',
        ]
    );
$event_table->setOption('type', 'InnoDB');
$event_table->setOption('charset', 'utf8mb4');
$event_table->setOption('collate', 'utf8mb4_general_ci');

$connection->createTable($event_table);

// Install enriced attribute
$installer->addAttribute($entityTypeId, 'enriched', [
    'type'                      => 'int',
    'label'                     => 'Enriched',
    'input'                     => 'select',
    'global'                    => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    'visible'                   => false,
    'required'                  => false,
    'default'                   => 1,
    'is_configurable'           => false,
    'used_in_product_listing'   => false,
    'source'                    => 'eav/entity_attribute_source_boolean ',
]);
$installer->addAttributeToSet($entityTypeId, $setId, 'Event integration', 'enriched');

$installer->endSetup();
