<?php

class Awardit_EventListener_Model_Resource_Event_Log extends Mage_Core_Model_Resource_Db_Abstract
{
    /**
     * Define main table and primary key.
     */
    protected function _construct(): void
    {
        $this->_init('awardit_eventlistener/event_log', 'log_id');
    }

    /**
     * Load data by specified input
     * @return false|array
     */
    public function loadLatest(int $product_id, ?int $store_id, string $event_type)
    {
        $adapter = $this->_getReadAdapter();
        $select = $adapter->select()
            ->from($this->getMainTable())
            ->where('product_id=:product_id')
            ->where('(store_id=:store_id) OR store_id IS NULL')
            ->where('event_type=:event_type')
            ->order('revision ' . Varien_Db_Select::SQL_DESC)
            ->order('store_id ' . Varien_Db_Select::SQL_DESC)
            ->limit(1);
        $binds = [
            'product_id' => $product_id,
            'store_id' => $store_id,
            'event_type' => $event_type,
        ];
        return $adapter->fetchRow($select, $binds);
    }
}
