<?php

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_EventListener_Block_TaxMapping extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract
{
    /**
     * @var Awardit_EventListener_Block_TaxClasses|null
     */
    private $renderer = null;

    /**
     * Retrieve email templates
     * @return Awardit_EventListener_Block_TaxClasses
     */
    protected function getTaxClasses(): Awardit_EventListener_Block_TaxClasses
    {
        if (is_null($this->renderer)) {
            /** @var Mage_Core_Model_Layout */
            $layout = $this->getLayout();
            /** @var Awardit_EventListener_Block_TaxClasses */
            $this->renderer = $layout->createBlock(
                'awardit_eventlistener/taxClasses',
                '',
                ['is_render_to_js_template' => true]
            );
            $this->renderer->setClass('customer_group_select');
        }
        return $this->renderer;
    }

    /**
     * Prepare to render
     */
    protected function _prepareToRender(): void
    {
        $helper = Mage::helper('awardit_eventlistener');
        $this->addColumn('erp_tax_code', [
            'label' => $helper->__('ERP Tax class'),
        ]);
        $this->addColumn('tax_class_id', [
            'label' => $helper->__('Product tax class'),
            'renderer' => $this->getTaxClasses(),
        ]);
        $this->_addAfter = false;
        $this->_addButtonLabel = $helper->__('Add tax mapping');
    }

    /**
     * Prepare existing row data object
     * @param Varien_Object $row
     */
    protected function _prepareArrayRow(Varien_Object $row): void
    {
        $row->setData(
            'option_extra_attr_' . $this->getTaxClasses()->calcOptionHash($row->getData('tax_class_id')),
            'selected="selected"'
        );
    }
}
