<?php

/**
 * Installs attributes related to AWS events.
 */

/**
 * @var Mage_Catalog_Model_Resource_Setup $installer
 * @psalm-suppress InvalidScope
 */
$installer = $this;
$installer->startSetup();

$installer->addAttribute(Mage_Catalog_Model_Product::ENTITY, 'lowest_sale_price', [
    'group'                     => 'Prices',
    'backend'                   => 'catalog/product_attribute_backend_price',
    'frontend'                  => '',
    'label'                     => 'Lowest sale price 30 days',
    'type'                      => 'decimal',
    'input'                     => 'price',
    'global'                    => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
    'visible'                   => true,
    'required'                  => false,
    'default'                   => false,
    'is_configurable'           => false,
    'user_defined'              => false,
    'visible_on_front'          => true,
    'used_in_product_listing'   => true
]);

$installer->endSetup();
