<?php

use Mage_Adminhtml_Block_Widget_Tab_Interface as Tab;

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_EventListener_Block_Product_Edit extends Mage_Adminhtml_Block_Widget implements Tab
{
    public function __construct()
    {
        parent::__construct();
        $this->setTemplate('event_listener/product/edit.phtml');
    }

    public function getTabLabel(): string
    {
        return "Event integration";
    }

    public function getTabTitle(): string
    {
        return "Event integration";
    }

    public function canShowTab(): bool
    {
        return true;
    }

    public function isHidden(): bool
    {
        return false;
    }

    public function formatDateTime(string $date): string
    {
        return Mage::app()->getLocale()
            ->date($date, Varien_Date::DATETIME_INTERNAL_FORMAT)
            ->toString();
    }
}
