<?php

class Awardit_EventListener_EventException extends RuntimeException
{
    private bool $permanent;

    public function __construct(string $message, bool $permanent, Throwable $parent = null)
    {
        $this->permanent = $permanent;
        parent::__construct(
            $message . (
                $permanent
                ? ', removing from queue'
                : ', keeping in queue'
            ),
            0,
            $parent
        );
    }

    public function isPermanent(): bool
    {
        return $this->permanent;
    }
}
