<?php

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_EventListener_Block_TaxClasses extends Mage_Core_Block_Html_Select
{
    /* @var array|null */
    private ?array $tax_classes = null;

    /**
     * Retrieve tax classes
     * @return array
     */
    protected function getTaxClasses(): array
    {
        if (is_null($this->tax_classes)) {
            $this->tax_classes = [];
            $collection = Mage::getModel('tax/class')->getCollection();
            foreach ($collection as $tax_class) {
                /* @var Mage_Customer_Model_Tax_class $tax_class */
                if ($tax_class->getClassType() == Mage_Tax_Model_Class::TAX_CLASS_TYPE_PRODUCT) {
                    $this->tax_classes[$tax_class->getId()] = $tax_class->getClassName();
                }
            }
            natsort($this->tax_classes);
        }
        return $this->tax_classes;
    }

    /**
     * @param string $value
     * @return Awardit_EventListener_Block_TaxClasses
     */
    public function setInputName($value): Mage_Core_Block_Html_Select
    {
        return $this->setName($value);
    }

    /**
     * Render block HTML
     * @return string
     */
    public function _toHtml(): string
    {
        if (!$this->getOptions()) {
            foreach ($this->getTaxClasses() as $tax_class_id => $tax_class_label) {
                $this->addOption($tax_class_id, addslashes($tax_class_label));
            }
        }
        return parent::_toHtml();
    }
}
