<?php

class Awardit_Integration_Model_Cli_MagentoConfig extends Awardit_Integration_Model_Cli {

    // -m=MagentoConfig -f=setTaxTranslation
    public function CLI_setTaxTranslation($param)
    {
        $instanceId = Mage::helper($this->_defaultHelper)->getInstanceId();
        if (empty($instanceId)) {
            echo "Instance id not configured!\n";
            return;
        }

        $tax = $this->getTaxData();

        $values = [

            // $tax[ currency_id ][ country_id ][ "tax_percent" ]

            "(:instanceId, {$tax[0][0]["25"]}, 1, 25, 0, 0, 1)",
            "(:instanceId, {$tax[0][0]["12"]}, 2, 12, 0, 0, 2)",
            "(:instanceId, {$tax[0][0]["6"]}, 3, 6, 0, 0, 3)",
            "(:instanceId, 0, 27, 0, 0, 0, 27)",
            "(:instanceId, {$tax[45][0]["25"]}, 2, 25, 45, 0, 1)",
            "(:instanceId, {$tax[45][0]["25"]}, 3, 25, 45, 0, 1)",
            "(:instanceId, {$tax[45][0]["25"]}, 1, 25, 45, 0, 1)",
            "(:instanceId, 0, 27, 0, 45, 0, 2)",
            "(:instanceId, {$tax[46][0]["25"]}, 1, 25, 46, 0, 1)",
            "(:instanceId, {$tax[46][0]["12"]}, 2, 12, 46, 0, 2)",
            "(:instanceId, {$tax[46][0]["6"]}, 3, 6, 46, 0, 3)",
            "(:instanceId, 0, 27, 0, 46, 0, 27)",
            "(:instanceId, {$tax[47][0]["25"]}, 1, 25, 47, 0, 3)",
            "(:instanceId, {$tax[47][0]["15"]}, 2, 15, 47, 0, 13)",
            "(:instanceId, {$tax[47][0]["12"]}, 3, 12, 47, 0, 15)",
            "(:instanceId, 0, 27, 0, 47, 0, 27)",
            "(:instanceId, {$tax[99][0]["25"]}, 1, 25, 99, 0, 1)",
            "(:instanceId, {$tax[99][0]["12"]}, 2, 12, 99, 0, 2)",
            "(:instanceId, {$tax[99][0]["6"]}, 3, 6, 99, 0, 3)",
            "(:instanceId, 0, 27, 0, 99, 0, 27)",
            "(:instanceId, {$tax[0][0]["25"]}, 1, 25.5, 99, 358, 11)",
            "(:instanceId, {$tax[99][358]["25.5"]}, 1, 25.5, 99, 358, 11)",
            "(:instanceId, {$tax[0][0]["12"]}, 2, 14, 99, 358, 12)",
            "(:instanceId, {$tax[99][358]["14"]}, 2, 14, 99, 358, 12)",
            "(:instanceId, {$tax[0][0]["6"]}, 3, 10, 99, 358, 13)",
            "(:instanceId, {$tax[99][358]["10"]}, 3, 10, 99, 358, 13)",
            "(:instanceId, 0, 27, 0, 99, 358, 14)\n"
        ];

        $sqlQuery = "INSERT IGNORE INTO `tax_translations` (`magento_instance`, `magento_tax_id`, `swedish_visma_tax_id`, `tax_percent`, `currency_id`, `country_id`, `local_visma_tax_id`) VALUES\n";
        $sqlQuery .= implode(",\n", $values);

        $stmt = Mage::getSingleton("core/resource")->getConnection("integration_write")->prepare($sqlQuery);
        $stmt->bindValue("instanceId", $instanceId);

        try {
            $stmt->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
            echo $ex->getTraceAsString();
            die();
        }
    }

    public function getTaxData()
    {
        $sqlQuery = "SELECT * FROM tax_class WHERE class_type = 'PRODUCT'";
        $taxClasses = Mage::getSingleton("core/resource")->getConnection("core_read")->fetchAll($sqlQuery);

        if (empty($taxClasses)) {
            return [];
        }

        $tax = [];
        foreach ($taxClasses as $row) {
            $values = [];
            $status = preg_match("/^([0-9\.]+)\% \((.*)\)$/", $row["class_name"], $values);
            if ($status !== 1) {
                continue;
            }

            // $values[1] = tax percent, $values[2] = country name
            if (empty($values[1]) || empty($values[2])) {
                continue;
            }
            $countryName = $values[2];
            $taxPercent = $values[1];
            $currencyId = $this->getCurrencyIdByCountryName($countryName);
            $countryId = $this->getCountryIdByCountryName($countryName);

            $tax[ $currencyId ][ $countryId ][ $taxPercent ] = intval($row["class_id"]);

            // Special "default" values
            if ($currencyId === 46) {
                if (empty($tax[0][0][ $taxPercent ])) {
                    $tax[0][0][ $taxPercent ] = intval($row["class_id"]);
                }
                if (empty($tax[99][0][ $taxPercent ])) {
                    $tax[99][0][ $taxPercent ] = intval($row["class_id"]);
                }
            }

            // Special values for some countries
            if ($countryId > 0 && empty($tax[99][ $countryId ][ $taxPercent ])) {
                $tax[99][ $countryId ][ $taxPercent ] = intval($row["class_id"]);
            }
        }

        return $tax;
    }

    public function getCurrencyIdByCountryName($countryName)
    {
        switch (strtolower($countryName)) {
            case "denmark":
                return 45;
            case "sweden":
                return 46;
            case "norway":
                return 47;
            default:
                return 99;
        }
    }

    public function getCountryIdByCountryName($countryName)
    {
        switch (strtolower($countryName)) {
            case "finland":
                return 358;
            default:
                return 0;
        }
    }
}
