# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [A variation of calendar-based versioning](https://awardit.atlassian.net/wiki/spaces/ITOPS/pages/625311761/Workflows+for+Software+Change+Management#Versioning).

## [Unreleased]

## [v2.3.1]

### Added

- System to blacklist items and stop them from being exported.

### Changed

- Renamed file/class of email blacklist to reflect what it actually does.

## [v2.3.0]

### Added

- Controller and model for order manager

### Changed

- Changed when to expand fake bundle

## [v2.2.2]

### Added

- Added config values for default text for attribute estimated_delivery_days when new product is created by product import.
- Create the product attributes "awardit_dropship" and "estimated_delivery_days" if they don't already exist.
- Added flag for cli to generate xml-data even if store is configured to not export orders. Usefull when testing.
- Added code for expanding "fake" bundles

### Changed

- Bumped module version to 2.0.1

## [v2.2.1]

### Added

- Added support for new payment method, Altapay

## [v2.2.0]

### Changed
- Save xml data in database instead of filesystem.
- Remove obsolete code and config related to saving xml as file

### Fixed
- When used as index, moms is not supposed to be an integer

## [v2.1.5]

### Fixed

- Fixed multiple bugs with stock sync. Two syntax errors that stopped the job and adjusting default value for warehouse_id.

## [v2.1.4]

### Fixed
- Copy stock sync from old integration module and refactor it to work here
- Set special visma tax class id for discounts when 0% tax and order is destined for visma company F0001
- Product import for new stores generates error before file cache is cleared, this fix ignores the error condition

### Changed
- Do not ship dropship products

## [v2.1.3]

### Changed

- Make sure surver running JoLo-scripts can reach all Magento instances
- Changed some logging to not use custom function
- Did some cleanup of data, changing/removing some functions

### Added

- Added functions to be able to copy attribute options

## [v2.1.2]

### Changed

- Changed how group prices is set
- Changed information in email about price problems
- Changed email addresses to use correct domain

### Added

- Added warning email for when customer group is missing in Magento

## [v2.1.1]

### Added

- Added CHANGELOG.md

### Changed

- Fixed typo in product import
- Changed the way stock is updated


## [v2.1.0]

### Changed

- Add possibility to use store code instead of store id in order export


## [v2.0.2]

### Changed

- Fixed typo, CSS class was placed wrong


## [v2.0.1]

### Changed
 
- Fixed a visual issue in Magento Admin for bonusqueue


## [v2.0.0]

### Changed

- Major overhaul of what was previously known as accrual, now called bonusqueue
- Order export now looks for slightly older orders when finding out what to export
