<?php

class Awardit_Integration_OrdermanagerController extends Mage_Core_Controller_Front_Action
{

    private $_orderModel = null;

    public function getOrderModel()
    {
        if (empty($this->_orderModel)) {
            $this->_orderModel = Mage::getModel("integration/LocalOrdermanager") ?: Mage::getModel("integration/Ordermanager");
        }
        return $this->_orderModel;
    }

    // run by: /integration/ordermanager/index
    public function indexAction()
    {
        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setBody("The End");
    }

    // run by: /integration/ordermanager/refund
    public function refundAction()
    {
        $locale = "en_US";
        Mage::helper("integration")->checkIP();
        Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);
        Mage::app()->getLocale()->setLocaleCode($locale);
        Mage::getSingleton("core/translate")->setLocale($locale)->init("adminhtml", true);

        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setHeader("Content-type", "application/json");

        do {
            if (empty($_POST["data"])) {
                $result = [
                    "status" => 0,
                    "message" => "Missing input!\n"
                ];
                break;
            }

            $input = json_decode($_POST["data"], true);
            if (!is_array($input)) {
                $result = [
                    "status" => 0,
                    "message" => "Unable to decode input!\n"
                ];
                break;
            }

            if (empty($input["incrementId"])) {
                $result = [
                    "status" => 0,
                    "message" => "Missing order!\n"
                ];
                break;
            }
            $incrementId = $input["incrementId"];

            $username = "unknown";
            if (!empty($input["username"])) {
                $username = $input["username"];
            }

            $result = $this->getOrderModel()->refundOrder($incrementId, $username);

        } while(false);

        $this->getResponse()->setBody(json_encode($result, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
    }

}
