<?php

class Awardit_Integration_Block_Adminhtml_Bonusqueue extends Mage_Adminhtml_Block_Template
{
    public function getBonusQueueItems()
    {
        if (!Mage::getSingleton('admin/session')->isAllowed(Awardit_Integration_Helper_Data::BONUS_QUEUE_ACL_ORDER_INFO)) {
            return [];
        }

        // Found in Mage_Adminhtml_Block_Sales_Order_View
        $order = Mage::registry("sales_order");
        $sqlQuery = "SELECT * FROM " . Awardit_Integration_Helper_Data::INTEGRATION_TABLE_BONUS_QUEUE . " WHERE order_id = ?";
        $queueItems = Mage::getSingleton("core/resource")->getConnection("core_read")->fetchAll($sqlQuery, $order->getId());
        if (empty($queueItems)) {
            return [];
        }

        foreach (array_keys($queueItems) as $index) {
            $queueItems[$index]["processing_date"] = date("Y-m-d", strtotime($queueItems[$index]["processing_date"]));

            switch (intval($queueItems[$index]["processed_status"])) {
                case Awardit_Integration_Model_Cli_Accrual::BONUS_QUEUE_PROCESSED_STATUS_WAITING:
                    $queueItems[$index]["processed_status_text"] = "Waiting";
                    break;

                case Awardit_Integration_Model_Cli_Accrual::BONUS_QUEUE_PROCESSED_STATUS_DONE:
                    $queueItems[$index]["processed_status_text"] = "Done";
                    break;

                case Awardit_Integration_Model_Cli_Accrual::BONUS_QUEUE_PROCESSED_STATUS_CANCELED:
                    $queueItems[$index]["processed_status_text"] = "Canceled";
                    break;

                case Awardit_Integration_Model_Cli_Accrual::BONUS_QUEUE_PROCESSED_STATUS_ERROR:
                    $queueItems[$index]["processed_status_text"] = "Error";
                    break;

                default:
                    $queueItems[$index]["processed_status_text"] = "Unknown";
                    break;
            }

            $queueItems[$index]["processed_result_decoded"] = [];
            if (!empty($queueItems[$index]["processed_result"])) {
                $result = json_decode($queueItems[$index]["processed_result"], true);
                $queueItems[$index]["processed_result_decoded"] = $result ?? [];
            }
        }

        return $queueItems;

    }

}