<?php

class Awardit_Integration_Model_Cli extends Mage_Core_Model_Abstract {
    /**
     * @var int
     */
    const CLI_DEFAULT_ITERATION_LIMIT = 100;

    /**
     * @var string
     */
    protected $_defaultHelper = "integration";

    /**
     * @var bool
     */
    protected $_debugMode = false;

    /**
     * @var bool
     */
    protected $_testMode = false;

    /**
     * @var int
     */
    protected $_limit = Awardit_Integration_Model_Cli::CLI_DEFAULT_ITERATION_LIMIT;

    /**
     * @var bool
     */
    protected $_timedPricesModel = null;

    /**
     * @return \Awardit_Integration_Model_TimedPrices
     */
    public function getTimedPricesModel()
    {
        if (empty($this->_timedPricesModel)) {
            $this->_timedPricesModel = Mage::getModel("integration/TimedPrices");
        }
        return $this->_timedPricesModel;
    }

    /**
     * @param bool $mode
     * @return void
     */
    public function setDebugMode($mode)
    {
        $this->_debugMode = $mode ? true : false;
    }

    /**
     * @return bool
     */
    public function getDebugMode()
    {
        return $this->_debugMode;
    }

    /**
     * @param bool $mode
     * @return void
     */
    public function setTestMode($mode)
    {
        $this->_testMode = $mode ? true : false;
    }

    /**
     * @return bool
     */
    public function getTestMode()
    {
        return $this->_testMode;
    }

    /**
     * @return int
     */
    public function getDefaultLimit()
    {
        return Awardit_Integration_Model_Cli::CLI_DEFAULT_ITERATION_LIMIT;
    }

    /**
     * @param int $limit
     * @return void
     */
    public function setLimit($limit)
    {
        $this->_limit = intval($limit);
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->_limit;
    }

    /**
     *
     * @param string|null $inputParamStr
     * @param array $wantedParams
     * @return array
     * @throws Exception
     */
    public function extractParams($inputParamStr, $wantedParams)
    {
        //
        /*
         * example input: param1:1234,param2:49.99
         *
         * example config: (! denotes required parameter)
         * $wantedParams = [
         *     "param1" => "int",
         *     "!param2" => "float"
         * ];
         *
         * example output:
         * $extractedParams = [
         *     "param1" => 1234,
         *     "param2" => 49.99
         * ];
         *
         */

        if (empty($inputParamStr)) {
            $inputParamStr = "dummy:1701";
        }

        $inputParams = explode(",", $inputParamStr);
        if (empty($inputParams) || !is_array($inputParams)) {
            throw new Exception("Missing required parameter!");
        }

        $rawExtractedParams = [];
        foreach ($inputParams as $inputParam) {
            $keyVal = explode(":", $inputParam);
            if (empty($keyVal) || !is_array($keyVal) || count($keyVal) !== 2) {
                throw new Exception("Malformed parameter!");
            }
            $rawExtractedParams[$keyVal[0]] = $keyVal[1];
        }

        $parsedParams = [];
        foreach ($wantedParams as $param => $type) {

            $isRequired = false;
            if (stripos($param, "!") === 0) {
                $isRequired = true;
                $param = substr($param, 1);
            }

            if ($isRequired && !array_key_exists($param, $rawExtractedParams)) {
                throw new Exception("Missing required parameter: {$param}");
            } elseif(array_key_exists($param, $rawExtractedParams)) {
                switch ($type) {
                    case "int":
                        $parsedParams[$param] = intval($rawExtractedParams[$param]);
                        break;
                    case "float":
                        $parsedParams[$param] = floatval($rawExtractedParams[$param]);
                        break;
                    case "date":
                        $parsedParams[$param] = date("Y-m-d", strtotime($rawExtractedParams[$param]));
                        break;
                    case "string":
                    default:
                        $parsedParams[$param] = $rawExtractedParams[$param];
                        break;
                }
            }
        }

        return $parsedParams;

    }

}
