<?php

class Awardit_Integration_Helper_PointsCore extends Awardit_Integration_Helper_Data
{
    /**
     * @var string
     */
    const INTEGRATION_TABLE_ACCRUAL = "awardit_accrual";

    public function getPointsCoreId($store)
    {
        if (is_numeric($store)) {
            $store = Mage::app()->getStore($store);
        }
        $pointsCores = Mage::helper("points_core")->getEnabledTypeProviders($store);

        if (!is_array($pointsCores)) {
            return null;
        }

        $pointsCoreIds = array_keys($pointsCores);
        return $pointsCoreIds[0] ?? null;
    }

    public function getProductPoints($product, $store, $customerGroupId)
    {
        if (is_numeric($store)) {
            $store = Mage::app()->getStore($store);
        }

        $pointsCoreId = $this->getPointsCoreId($store->getId());
        if (empty($pointsCoreId)) {
            return null;
        }
        $pointsCoreProductPrice = Mage::getModel("points_core/product_price");
        $pointsCoreProductPrice->loadByStoreProductTypeCustomerGroupId(
            $store,
            $product,
            $pointsCoreId,
            $customerGroupId
        );
        return $pointsCoreProductPrice;
    }

    public function setPointsForProduct($points, $product, $store, $customerGroupId, $pointsCoreId)
    {
        if (is_numeric($store)) {
            $store = Mage::app()->getStore($store);
        }

        $price = Mage::getModel("points_core/product_price");
        $price->loadByStoreProductTypeCustomerGroupId(
            $store,
            $product,
            $pointsCoreId,
            $customerGroupId
        );

        if ($price->getPrice() == $points) {
            return $price->getId();
        }

        $price->setProductId($product->getId());
        $price->setStoreId($store->getId());
        $price->setCustomerGroupId($customerGroupId);
        $price->setType($pointsCoreId);
        $price->setPrice($points);
        $price->save();

        return $price->getId();
    }

    public function getPointsForProduct($product, $store, $customerGroupId, $pointsCoreId)
    {
        if (is_numeric($store)) {
            $store = Mage::app()->getStore($store);
        }

        $price = Mage::getModel("points_core/product_price");
        $price->loadByStoreProductTypeCustomerGroupId(
            $store,
            $product,
            $pointsCoreId,
            $customerGroupId
        );

        return $price->getId() ? $price->getPrice() : null;

    }
}