<?php
class Awardit_Integration_Model_Cli_PointsCoreCron extends Awardit_Integration_Model_Cli_Cron {

    protected $_defaultHelper = "integration/PointsCore";

    protected function _processProducts($processes, $updateStock = null)
    {
        if (empty($processes)) {
            return;
        }

        $model = Mage::getModel("integration/Cli_LocalProductImport") ?: Mage::getModel("integration/Cli_PointsCoreProductImport");
        $model->setLimit($this->getLimit());
        $model->setDebugMode($this->getDebugMode());
        if ($updateStock !== null) {
            $model->setUpdateStock($updateStock);
        }

        $this->setMaxRunningTime(Awardit_Integration_Model_Cli_Cron::CRON_MAX_RUNNING_TIME_PRODUCT_IMPORT);
        $taggedProducts = 0;
        $importedProducts = 0;

        if (!empty($processes["tag"])) {
            $productList = $model->getAllUpdatedProducts();
            $model->tagProductsForImport($productList);
            $taggedProducts = count($productList);
            Mage::helper($this->_defaultHelper)->log("Tagged {$taggedProducts} products for import.");
        }

        if (!empty($processes["import"])) {
            do {
                $integrationProduct = $model->getProductToImport();
                if (empty($integrationProduct)) {
                    break;
                }

                $model->mergeDataToProduct($integrationProduct);
                $model->updateIntegrationData($integrationProduct);
                if ($integrationProduct["import_status"] == Awardit_Integration_Model_Cli_ProductImport::IMPORT_STATUS_FETCHED) {
                    $model->importSingleProduct($integrationProduct);
                    $model->updateIntegrationData($integrationProduct);
                }

                if ($this->getLimit() > 0) {
                    if ($importedProducts++ >= $this->getLimit()) {
                        Mage::helper($this->_defaultHelper)->log("Limit reached, exiting.");
                        break;
                    }
                }

            } while ($this->checkRunningTime());

            if (!$this->checkRunningTime()) {
                Mage::helper($this->_defaultHelper)->log("Time limit reached, exiting.");
            }
        }

        Mage::helper($this->_defaultHelper)->log("Imported {$importedProducts} products.");

    }

    protected function _processOrders($processes)
    {
        if (empty($processes)) {
            return;
        }

        $model = Mage::getModel("integration/Cli_LocalOrderExport") ?: Mage::getModel("integration/Cli_PointsCoreOrderExport");
        $model->setLimit($this->getLimit());
        $model->setDebugMode($this->getDebugMode());
        $preparedOrders = 0;
        $updatedOrders = 0;
        $iterations = 0;

        if (!empty($processes["scan"])) {
            $model->scanForNewOrders();
        }

        if (!empty($processes["prepare"])) {
            $integrationOrders = $model->getAllOrdersToExport();

            if (!empty($integrationOrders)) {
                $maxQtyToExport = count($integrationOrders);

                Mage::helper($this->_defaultHelper)->log("Found {$maxQtyToExport} order to prepare.");

                foreach ($integrationOrders as $integrationOrder) {
                    $model->prepareSingleOrder($integrationOrder);

                    $preparedOrders++;
                    if ($this->getLimit() > 0) {
                        if ($preparedOrders >= $this->getLimit()) {
                            Mage::helper($this->_defaultHelper)->log("Limit reached, exiting.");
                            break;
                        }
                    }

                    if (!$this->checkRunningTime()) {
                        break;
                    }
                }
            }
        }

        if (!empty($processes["transfer"])) {
            if ($preparedOrders > 0) {
                if (!Mage::helper($this->_defaultHelper)->getSaveXMLDataToDB()) {
                    $model->transferAllOrdersToVisma();
                }
            }
        }

        if (!empty($processes["update"]) && $this->checkRunningTime()) {
            $ordersToUpdate = $model->getAllOrdersToUpdate();
            if (!empty($ordersToUpdate)) {
                $maxQtyToUpdate = count($ordersToUpdate);
                Mage::helper($this->_defaultHelper)->log("Found {$maxQtyToUpdate} orders to update.");
                foreach ($ordersToUpdate as $integrationOrder) {
                    $model->updateSingleOrder($integrationOrder);
                    $updatedOrders += $model->getWasLastOrderUpdated() ? 1 : 0;
                    $iterations++;
                    if ($this->getLimit() > 0) {
                        if ($iterations >= $this->getLimit()) {
                            Mage::helper($this->_defaultHelper)->log("Limit reached, exiting.");
                            break;
                        }
                    }

                    if (!$this->checkRunningTime()) {
                        break;
                    }
                }
            }
        }

        if (!$this->checkRunningTime()) {
            Mage::helper($this->_defaultHelper)->log("Time limit reached, exiting.");
        }

        if (!empty($preparedOrders) && !empty($updatedOrders)) {
            Mage::helper($this->_defaultHelper)->log("Exported {$preparedOrders} and updated {$updatedOrders} orders.");
        } elseif(!empty($preparedOrders)) {
            Mage::helper($this->_defaultHelper)->log("Exported {$preparedOrders} orders.");
        } elseif(!empty($updatedOrders)) {
            Mage::helper($this->_defaultHelper)->log("Updated {$updatedOrders} orders.");
        } else {
            Mage::helper($this->_defaultHelper)->log("Exported and updated no orders.");
        }

    }

}
