<?php

class Awardit_Integration_Model_Cli_PointsCoreProductImport extends Awardit_Integration_Model_Cli_ProductImport {

    protected $_defaultHelper = "integration/PointsCore";

    // SalePr2 in Visma is used for points (PointsCore)
    // SCd in Visma is used for accrual (PointsCore)
    private $extraVismaProductPriceFields = [ "SalePr2" => "points", "SCd" => "accrual" ];

    public function getExtraVismaProductPriceFields()
    {
        return array_merge($this->extraVismaProductPriceFields, parent::getExtraVismaProductPriceFields());
    }

    public function getExtraVismaProductPriceFieldsAsString()
    {
        $extraFields = [];

        foreach ($this->getExtraVismaProductPriceFields() as $field => $name) {
            $extraFields[] = "{$field} AS {$name}";
        }

        return implode(",", $extraFields) . (!empty($extraFields) ? "," : "");

    }

    public function importSingleProduct(&$integrationProduct, $iteration = 0, $maxQty = 0)
    {
        $status = parent::importSingleProduct($integrationProduct, $iteration, $maxQty);

        if (!$status) {
            return $status;
        }

        if (empty($integrationProduct["price_data"]) || $integrationProduct["import_status"] != Awardit_Integration_Model_Cli_ProductImport::IMPORT_STATUS_COMPLETE) {
            return $status;
        }

        // Get Magento store_id from Visma store_id and currency
        $productWebsites = Mage::helper($this->_defaultHelper)->getMagentoWebsiteIdsForProduct($integrationProduct["price_data"]);

        $productId = Mage::getModel("catalog/product")->getIdBySku($integrationProduct["sku"]);
        $globalProduct = Mage::getModel("catalog/product")->load($productId);
        $isUpdated = false;

        $pointsCollection = Mage::getResourceModel("points_core/product_price_collection");
        $pointsCollection->filterByProduct($globalProduct);
        $pointsItemCollection = $pointsCollection->getItems();

        foreach ($productWebsites as $websiteId) {
            $storeIds = Mage::helper($this->_defaultHelper)->getMagentoStoreIds($websiteId);
            foreach ($storeIds as $localStoreId) {
                $vismaCurrencyId = intval(Mage::helper($this->_defaultHelper)->getVismaCurrencyId(Mage::getStoreConfig("currency/options/base", $localStoreId)));
                $vismaShopId = intval(Mage::getStoreConfig("integration/general/visma_shop_id", $localStoreId));
                $pointsCoreId = Mage::helper($this->_defaultHelper)->getPointsCoreId($localStoreId);

                // If applicable: set points for PointsCore
                if (!empty($pointsCoreId)) {
                    foreach ($integrationProduct["price_data"] as $priceData) {
                        if ($priceData["currency_id"] == $vismaCurrencyId && $priceData["shop_id"] == $vismaShopId) {

                            // Set points
                            if ($priceData["points"] > 0) {
                                $customerGroupIds = Mage::helper($this->_defaultHelper)->getMagentoGroupIds($priceData["customer_group_id"]);
                                foreach ($customerGroupIds as $customerGroupId) {
                                    $pointsItemId = Mage::helper($this->_defaultHelper)->setPointsForProduct($priceData["points"], $globalProduct, $localStoreId, $customerGroupId, $pointsCoreId);
                                    if (!empty($pointsItemId) && array_key_exists($pointsItemId, $pointsItemCollection)) {
                                        unset($pointsItemCollection[$pointsItemId]);
                                    }
                                }
                            }
                        }
                    }
                }

                // If applicable: set accrual for PointsCore
                $accrualRate = Mage::getStoreConfig("sas/extrapoints/accrual_rate", $localStoreId);

                // Check if we have accrual rate and current product have accrual attribute
                if ($accrualRate > 0 && Mage::helper($this->_defaultHelper)->getAttributeIdByAttributeSetAndCode($globalProduct->getAttributeSetId(), "accrual")) {
                    $localProduct = Mage::getModel("catalog/product")->setStoreId($localStoreId)->load($globalProduct->getId());

                    foreach ($integrationProduct["price_data"] as $priceData) {
                        if ($priceData["shop_id"] == $vismaShopId && $priceData["currency_id"] == $vismaCurrencyId) {
                            if ($priceData["accrual"] > 0) {
                                $actualAccrual = ceil((($priceData["accrual"] / 100) / $accrualRate) * $localProduct->getPrice());
                                if ($localProduct->getData("accrual") != $actualAccrual) {
                                    $localProduct->setData("accrual", $actualAccrual)->getResource()->saveAttribute($localProduct, "accrual");
                                    $isUpdated = true;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }

        if (!empty($pointsItemCollection)) {
            foreach ($pointsItemCollection as $pointsItem) {
                $pointsItem->delete();
            }
        }

        // re-save product from default store, if updated
        if ($isUpdated) {
            try {
                $globalProduct->save();
                Mage::helper($this->_defaultHelper)->log("Successfully saved product.");
            } catch (Exception $exception) {
                Mage::helper($this->_defaultHelper)->logException($exception, "Exception while saving!");
                $integrationProduct["import_status"] = Awardit_Integration_Model_Cli_ProductImport::IMPORT_STATUS_ERROR;
                return false;
            }
        }

        $integrationProduct["import_status"] = Awardit_Integration_Model_Cli_ProductImport::IMPORT_STATUS_COMPLETE;
        return true;
    }

    public function getNewPriceIfZero($product, $storeId, $priceData)
    {
        $newPrice = parent::getNewPriceIfZero($product, $storeId, $priceData);
        $store = Mage::app()->getStore($storeId);
        $pointsCoreId = Mage::helper($this->_defaultHelper)->getPointsCoreId($store);
        if (!empty($pointsCoreId)) {

            $provider = Mage::helper("points_core")->getTypeProvider($pointsCoreId);
            if ($provider) {
                $rate = $provider->getProductFallbackRate($store, $product);
                if ($priceData["points"] > 0 && $rate > 0) {
                    $newPrice = $priceData["points"] / $rate;
                }
            }
        }

        return $newPrice;
    }

}
