<?php

class Awardit_Integration_Block_Adminhtml_Accrual extends Mage_Adminhtml_Block_Template
{
    public function getAccrualItem()
    {
        if (!Mage::getSingleton('admin/session')->isAllowed(Awardit_Integration_Model_Cli_Accrual::ACCRUAL_ACL_ORDER_INFO)) {
            return [];
        }

        // Found in Mage_Adminhtml_Block_Sales_Order_View
        $order = Mage::registry("sales_order");
        $sqlQuery = "SELECT * FROM " . Awardit_Integration_Helper_PointsCore::INTEGRATION_TABLE_ACCRUAL . " WHERE order_id = ?";
        $accrualData = Mage::getSingleton("core/resource")->getConnection("core_read")->fetchRow($sqlQuery, $order->getId());
        if (empty($accrualData)) {
            return [];
        }

        $accrualData["payout_date"] = date("Y-m-d", strtotime($accrualData["payout_date"]));

        switch (intval($accrualData["payout_status"])) {
            case Awardit_Integration_Model_Cli_Accrual::ACCRUAL_ORDER_PAYOUT_STATUS_WAITING:
                $accrualData["payout_status"] = "Waiting";
                break;

            case Awardit_Integration_Model_Cli_Accrual::ACCRUAL_ORDER_PAYOUT_STATUS_DONE:
                $accrualData["payout_status"] = "Done";
                break;

            case Awardit_Integration_Model_Cli_Accrual::ACCRUAL_ORDER_PAYOUT_STATUS_CANCELED:
                $accrualData["payout_status"] = "Canceled";
                break;

            case Awardit_Integration_Model_Cli_Accrual::ACCRUAL_ORDER_PAYOUT_STATUS_ERROR:
                $accrualData["payout_status"] = "Error";
                break;

            default:
                $accrualData["payout_status"] = "Unknown";
                break;
        }

        if (empty($accrualData["transaction_id"])) {
            $accrualData["transaction_id"] = "-";
        }

        return $accrualData;

    }

}