<?php

class Awardit_Integration_ProducthandlerController extends Mage_Core_Controller_Front_Action
{

    private $_productModel = null;

    public function getProductModel()
    {
        if (empty($this->_productModel)) {
            $this->_productModel = Mage::getModel("integration/LocalProducthandler") ?: Mage::getModel("integration/Producthandler");
        }
        return $this->_productModel;
    }

    // run by: /integration/producthandler/index
    public function indexAction()
    {
        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setBody("The End");
    }

    // run by: /integration/producthandler/server
    public function serverAction()
    {
        $locale = "en_US";
        Mage::helper("integration")->checkIP();
        Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);
        Mage::app()->getLocale()->setLocaleCode($locale);
        Mage::getSingleton("core/translate")->setLocale($locale)->init("adminhtml", true);

        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setHeader("Content-type", "application/json");
        $this->getResponse()->setBody(json_encode($this->getProductModel()->productHandler(), JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
    }

    // run by: /integration/producthandler/scanattributes
    public function scanattributesAction()
    {
        $locale = "en_US";
        Mage::helper("integration")->checkIP();
        Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);
        Mage::app()->getLocale()->setLocaleCode($locale);
        Mage::getSingleton("core/translate")->setLocale($locale)->init("adminhtml", true);

        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setHeader("Content-type", "application/json");
        $this->getResponse()->setBody(json_encode($this->getProductModel()->scanAttributes(), JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
    }
}
