<?php

class Awardit_Integration_AdministrationController extends Mage_Core_Controller_Front_Action
{

    // run by: /integration/administration/index
    public function indexAction()
    {
        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setBody("The End");
    }

    // run by: /integration/administration/getCron
    public function getCronAction()
    {
        $result = $this->handleGetCron();

        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setHeader("Content-type", "application/json");
        $this->getResponse()->setBody(json_encode($result, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
    }

    // run by: /integration/administration/runCron
    public function runCronAction()
    {
        $result = $this->handleRunCron($this->handleGetCron());

        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setHeader("Content-type", "application/json");
        $this->getResponse()->setBody(json_encode($result, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
    }

    public function handleGetCron()
    {
        if (empty($_POST["data"])) {
            return [
                "status" => 0,
                "message" => "Missing input!\n"
            ];
        }

        $input = json_decode($_POST["data"], true);
        if (!is_array($input)) {
            return [
                "status" => 0,
                "message" => "Unable to decode input!\n"
            ];
        }

        if (empty($input["instance"])) {
            return [
                "status" => 0,
                "message" => "Missing instance!\n"
            ];
        }

        $cron = file_get_contents("/etc/cron.d/integration");
        if (empty($cron)) {
            return [
                "status" => 0,
                "message" => "Unable to read cron file!\n"
            ];
        }

        $cronRows = explode("\n", $cron);
        if (empty($cronRows)) {
            return [
                "status" => 0,
                "message" => "Unable to parse cron file!\n"
            ];
        }

        foreach ($cronRows as $cronRow) {
            $matches = [];

            // Example: */30 0,7-23 * * *  www-data /usr/local/bin/magento_launcher.sh magento10a magento-integration-v2 -m=LocalCron -f=exportOrders
            // This expression is used for debugging as it includes lines marked as comment
            // $exp = sprintf("/^[ #]*([^ ]+ [^ ]+ [^ ]+ [^ ]+ [^ ]+) .* %s .* -f=exportOrders.*$/", $input["instance"]);

            // This expression is the default one
            $exp = sprintf("/^[ ]*([^ ]+ [^ ]+ [^ ]+ [^ ]+ [^ ]+) .* %s .* -f=exportOrders.*$/", $input["instance"]);

            if (preg_match($exp, $cronRow, $matches) === 1 && count($matches) === 2) {
                return [
                    "status" => 1,
                    "data" => $matches
                ];
            }
        }

        return [
            "status" => 0,
            "message" => "Found no row in cronfile matching instance!\n",
            "debug" => [
                "cronRows" => $cronRows
            ]
        ];
    }

    public function handleRunCron($result)
    {
        if (empty($result["status"]) || !empty($result["message"])) {
            return $result;
        }

        if (empty($result["data"][0])) {
            return [
                "status" => 0,
                "message" => "Found no script to run!\n",
                "debug" => [
                    "result" => $result
                ]
            ];
        }

        return [
            "status" => 1,
            "message" => "Not implemented yet!\n"
        ];
    }
}
