<?php

/*
 * This Magento instance uses PointsCore.
 * That's why we extend Awardit_Integration_Model_Cli_PointsCoreCron.
 * 
 */

class Awardit_Integration_Model_Cli_PointsCoreAwarditB2BCron extends Awardit_Integration_Model_Cli_PointsCoreCron {

    protected $_defaultHelper = "integration/LocalData";

    // -m=LocalCron -f=tagProducts
    public function CLI_tagProducts($param)
    {
        $start = new DateTime("now");
        Mage::helper($this->_defaultHelper)->log("Cron: Starting to tag updated products.");

        $processes = [
            "tag" => true,
            "import" => false,
        ];
        $this->_processProducts($processes, null);

        $end = new DateTime("now");
        $diff = $start->diff($end);
        Mage::helper($this->_defaultHelper)->log("Cron: product tagging script ran for {$diff->format("%H:%I:%S")}\n");
    }

    // -m=LocalCron -f=importProducts
    public function CLI_importProducts($param)
    {
        $start = new DateTime("now");
        Mage::helper($this->_defaultHelper)->log("Cron: Starting to import queued products.");

        $wantedParams = [ "updateStock" => "int" ];
        $extractedParams = $this->extractParams($param, $wantedParams);
        $updateStock = null;
        if (array_key_exists("updateStock", $extractedParams)) {
            $updateStock = empty($extractedParams["updateStock"]) ? false : true;
        }

        $processes = [
            "tag" => false,
            "import" => true,
        ];
        $this->_processProducts($processes, $updateStock);

        $end = new DateTime("now");
        $diff = $start->diff($end);
        Mage::helper($this->_defaultHelper)->log("Cron: product import script ran for {$diff->format("%H:%I:%S")}\n");
    }

}
