<?php

class Awardit_Integration_Model_AdminObserver implements Awardit_AdminExtensions_Common_GridInterface
{
    private $_externalStockEnabled = false;

    public function __construct()
    {
        $this->_externalStockEnabled = Mage::getStoreConfig(
            'integration/external_stock/enabled',
            Mage::app()->getStore()->getId()
        ) ? true : false;
    }

    public function addColumns(Varien_Event_Observer $observer): void
    {
        if (!$this->_externalStockEnabled) {
            return;
        }

        $handler = $observer['handler'];
        $catalogHelper = Mage::helper('catalog');
        $handler->enableColumn('qty', [
            'header' => $catalogHelper->__('Qty'),
            'filter' => false,
            'sortable' => false,
            'renderer' => 'integration/renderer_qty',
            'table' => 'cataloginventory/stock_item',
            'field' => 'qty',
            'bind' => 'product_id=entity_id',
            'cond' => '{{table}}.stock_id=1',
        ], self::COL_DEFAULT);
    }
}
