<?php
$installer = $this;
$installer->startSetup();

$tableName = Awardit_Integration_Helper_Data::INTEGRATION_TABLE_BONUS_QUEUE;

$installer->run("
CREATE TABLE IF NOT EXISTS `{$tableName}` (
    `order_id` INT(10) UNSIGNED NOT NULL,
    `increment_id` VARCHAR(50) NOT NULL COLLATE 'utf8_general_ci',
    `bonus_type` VARCHAR(50) NOT NULL COLLATE 'utf8_general_ci',
    `bonus_value` INT(10) UNSIGNED NOT NULL DEFAULT '0',
    `extra_data` TEXT NULL DEFAULT '{}' COMMENT 'JSON encoded' COLLATE 'utf8_general_ci',
    `processing_date` DATE NOT NULL,
    `processing_tries` TINYINT(3) UNSIGNED NOT NULL DEFAULT '1',
    `processed_at` TIMESTAMP NULL DEFAULT NULL,
    `processed_status` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 = Waiting, 1 = Processed, 8 = Canceled, 9 = Error',
    `processed_result` TEXT NULL DEFAULT '{}' COMMENT 'JSON encoded' COLLATE 'utf8_general_ci',
    PRIMARY KEY (`order_id`, `bonus_type`) USING BTREE,
    INDEX `increment_idx` (`increment_id`, `bonus_type`) USING BTREE,
    INDEX `processing_idx` (`bonus_type`, `processing_date`, `processed_status`) USING BTREE,
    CONSTRAINT `FK1_a_i_customer_bonus_sales_flat_order` FOREIGN KEY (`order_id`) REFERENCES `sales_flat_order` (`entity_id`) ON UPDATE CASCADE ON DELETE CASCADE
)
COMMENT='Queue for bonus processing'
COLLATE='utf8_general_ci'
ENGINE=InnoDB
");

$installer->endSetup();
