<?php

/* Override controller:
 * http://inchoo.net/magento/overriding-magento-blocks-models-helpers-and-controllers/
 * http://inchoo.net/dev-talk/how-to-extend-magento-core-controller/
 * http://code.tutsplus.com/tutorials/understand-overriding-in-magento-controllers--cms-23386
 */

require_once 'Mage/Adminhtml/controllers/Customer/GroupController.php';

class Awardit_Integration_Override_Adminhtml_Customer_GroupController extends Mage_Adminhtml_Customer_GroupController
{

    public function saveAction()
    {
        $customerGroup = Mage::getModel('customer/group');
        $id = $this->getRequest()->getParam('id');
        if (!is_null($id)) {
            $customerGroup->load((int) $id);
        }

        $taxClass = (int) $this->getRequest()->getParam('tax_class');

        if ($taxClass) {
            try {
                $customerGroupCode = (string) $this->getRequest()->getParam('code');

                // Start: Added code
                $vismaGroupId = (string) $this->getRequest()->getParam('visma_group_id');
                if (is_numeric($vismaGroupId)) {
                    $customerGroup->setVismaGroupId(intval($vismaGroupId));
                }
                // End

                if (!empty($customerGroupCode)) {
                    $customerGroup->setCode($customerGroupCode);
                }

                $customerGroup->setTaxClassId($taxClass)->save();
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('customer')->__('The customer group has been saved.'));
                $this->getResponse()->setRedirect($this->getUrl('*/customer_group'));
                return;
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                Mage::getSingleton('adminhtml/session')->setCustomerGroupData($customerGroup->getData());
                $this->getResponse()->setRedirect($this->getUrl('*/customer_group/edit', [ 'id' => $id ]));
                return;
            }
        } else {
            $this->_forward('new');
        }
    }

}
